/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.caselink;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.core.service.GetMailboxesUnrestricted;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public class CreateCaseLink {
    protected CoreSession session;
    protected CaseLink createdPost;
    protected final String subject;
    protected final String comment;
    protected final Case envelope;
    protected final Mailbox sender;
    protected final String recipientId;
    protected final Map<String, List<String>> internalRecipients;
    protected final Map<String, List<String>> externalRecipients;
    protected final boolean isSent;
    protected final boolean isInitial;
    protected CaseLink draft;
    protected Mailbox recipient;
    protected boolean isActionable = false;
    protected String validateId;
    protected String refuseId;
    protected String stepId;

    public CaseLink getCreatedPost() {
        return this.createdPost;
    }

    public CreateCaseLink(CaseLink draft, CoreSession session, String subject, String comment, Case envelope, Mailbox sender, String recipientId, Map<String, List<String>> internalRecipients, Map<String, List<String>> externalRecipients, boolean isSent, boolean isInitial) {
        this.draft = draft;
        this.comment = comment;
        this.envelope = envelope;
        this.subject = subject;
        this.sender = sender;
        this.recipientId = recipientId;
        this.internalRecipients = internalRecipients;
        this.externalRecipients = externalRecipients;
        this.isSent = isSent;
        this.isInitial = isInitial;
        if (draft != null) {
            this.isActionable = draft.isActionnable();
        }
        this.session = session;
    }

    public void create() throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        GetMailboxesUnrestricted getMailboxesUnrestricted = new GetMailboxesUnrestricted(this.session, this.recipientId);
        getMailboxesUnrestricted.runUnrestricted();
        List<Mailbox> mailboxes = getMailboxesUnrestricted.getMailboxes();
        if (mailboxes == null || mailboxes.isEmpty()) {
            throw new CaseManagementException("Can't send post because sender mailbox does not exist.");
        }
        this.recipient = mailboxes.get(0);
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        this.recipient = mailboxes.get(0);
        DocumentModel doc = this.session.createDocumentModel(this.recipient.getDocument().getPathAsString(), UUID.randomUUID().toString(), correspDocumentTypeService.getCaseLinkType());
        if (this.draft != null) {
            doc.copyContent(this.draft.getDocument());
        }
        CaseLink post = (CaseLink)doc.getAdapter(CaseLink.class);
        if (this.isInitial) {
            post.addInitialInternalParticipants(this.internalRecipients);
            post.addInitialExternalParticipants(this.externalRecipients);
        }
        post.setActionnable(this.isActionable);
        if (this.isActionable) {
            doc.putContextData("initialLifecycleState", (Serializable)((Object)CaseLink.CaseLinkState.todo.name()));
        }
        post.addParticipants(this.internalRecipients);
        post.addParticipants(this.externalRecipients);
        this.setPostValues(doc);
        this.session.createDocument(doc);
        this.createdPost = (CaseLink)doc.getAdapter(CaseLink.class);
    }

    protected void setPostValues(DocumentModel doc) throws ClientException {
        doc.setPropertyValue("cslk:draft", (Serializable)Boolean.valueOf(false));
        doc.setPropertyValue("dc:title", (Serializable)((Object)this.subject));
        doc.setPropertyValue("cslk:caseRepositoryName", (Serializable)((Object)this.envelope.getDocument().getRepositoryName()));
        doc.setPropertyValue("cslk:caseDocumentId", (Serializable)((Object)this.envelope.getDocument().getId()));
        if (this.sender != null) {
            doc.setPropertyValue("cslk:senderMailboxId", (Serializable)((Object)this.sender.getId()));
            doc.setPropertyValue("cslk:sender", (Serializable)((Object)this.sender.getOwner()));
        }
        doc.setPropertyValue("cslk:date", (Serializable)Calendar.getInstance().getTime());
        doc.setPropertyValue("cslk:comment", (Serializable)((Object)this.comment));
        doc.setPropertyValue("cslk:isSent", (Serializable)Boolean.valueOf(this.isSent));
    }
}

