/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.caselink;

import java.io.Serializable;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;

public class UpdateCaseLinkUnrestricted
extends UnrestrictedSessionRunner {
    protected CaseLink post;
    protected final String subject;
    protected final String comment;
    protected final Case envelope;
    protected final Mailbox sender;
    protected final String recipientId;
    protected final Map<String, List<String>> internalRecipients;
    protected final Map<String, List<String>> externalRecipients;
    protected final boolean isSent;
    protected final boolean isInitial;
    protected Mailbox recipient;

    public CaseLink getUpdatedPost() {
        return this.post;
    }

    public UpdateCaseLinkUnrestricted(CoreSession session, String subject, String comment, Case envelope, Mailbox sender, String recipientId, Map<String, List<String>> internalRecipients, Map<String, List<String>> externalRecipients, boolean isSent, boolean isInitial, CaseLink post) {
        super(session);
        this.comment = comment;
        this.envelope = envelope;
        this.subject = subject;
        this.sender = sender;
        this.recipientId = recipientId;
        this.internalRecipients = internalRecipients;
        this.externalRecipients = externalRecipients;
        this.isSent = isSent;
        this.isInitial = isInitial;
        this.post = post;
    }

    public void run() throws ClientException {
        DocumentModel doc = this.post.getDocument();
        CaseLink post = (CaseLink)doc.getAdapter(CaseLink.class);
        if (this.isInitial) {
            post.addInitialInternalParticipants(this.internalRecipients);
            post.addInitialExternalParticipants(this.externalRecipients);
        }
        post.addParticipants(this.internalRecipients);
        post.addParticipants(this.externalRecipients);
        this.setPostValues(doc);
        this.session.saveDocument(doc);
        this.post = (CaseLink)doc.getAdapter(CaseLink.class);
    }

    protected void setPostValues(DocumentModel doc) throws ClientException {
        doc.setPropertyValue("cslk:draft", (Serializable)Boolean.valueOf(false));
        doc.setPropertyValue("dc:title", (Serializable)((Object)this.subject));
        doc.setPropertyValue("cslk:caseRepositoryName", (Serializable)((Object)this.envelope.getDocument().getRepositoryName()));
        doc.setPropertyValue("cslk:caseDocumentId", (Serializable)((Object)this.envelope.getDocument().getId()));
        doc.setPropertyValue("cslk:senderMailboxId", (Serializable)((Object)this.sender.getId()));
        doc.setPropertyValue("cslk:sender", (Serializable)((Object)this.sender.getOwner()));
        doc.setPropertyValue("cslk:date", (Serializable)Calendar.getInstance().getTime());
        doc.setPropertyValue("cslk:comment", (Serializable)((Object)this.comment));
        doc.setPropertyValue("cslk:isSent", (Serializable)Boolean.valueOf(this.isSent));
    }
}

