/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.io.Serializable;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.content.template.service.PostContentCreationHandler;

public class CaseManagementStructureHandler
implements PostContentCreationHandler {
    public static final String DC_TITLE = "dc:title";

    public void execute(CoreSession session) {
        try {
            PathRef sectionsPath;
            PathRef mailboxPath;
            PathRef cmfDomainPath = new PathRef("/case-management");
            if (!session.exists((DocumentRef)cmfDomainPath)) {
                DocumentModel caseContainer = session.createDocumentModel("/", "case-management", "CMFDomain");
                caseContainer.setPropertyValue(DC_TITLE, (Serializable)((Object)"Case Management"));
                DocumentModel cmfDomain = session.createDocument(caseContainer);
                ACP acp = cmfDomain.getACP();
                ACL localACL = acp.getOrCreateACL();
                ACE admins = new ACE("administrators", "Everything", true);
                ACE admin = new ACE("Administrator", "Everything", true);
                localACL.add((Object)admins);
                localACL.add((Object)admin);
                ACE blockInheritance = new ACE("Everyone", "Everything", false);
                localACL.add((Object)blockInheritance);
                cmfDomain.setACP(acp, true);
            } else {
                DocumentModel cmfDomain = session.getDocument((DocumentRef)cmfDomainPath);
            }
            PathRef casePath = new PathRef("/case-management/case-root");
            if (!session.exists((DocumentRef)casePath)) {
                DocumentModel caseContainer = session.createDocumentModel("/case-management", "case-root", "CaseRoot");
                caseContainer.setPropertyValue(DC_TITLE, (Serializable)((Object)"Case"));
                session.createDocument(caseContainer);
            }
            if (!session.exists((DocumentRef)(mailboxPath = new PathRef("/case-management/mailbox-root")))) {
                DocumentModel caseContainer = session.createDocumentModel("/case-management", "mailbox-root", "MailboxRoot");
                caseContainer.setPropertyValue(DC_TITLE, (Serializable)((Object)"Mailbox"));
                session.createDocument(caseContainer);
            }
            if (!session.exists((DocumentRef)(sectionsPath = new PathRef("/case-management/sections")))) {
                DocumentModel caseContainer = session.createDocumentModel("/case-management", "sections", "SectionRoot");
                caseContainer.setPropertyValue(DC_TITLE, (Serializable)((Object)"Sections"));
                session.createDocument(caseContainer);
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

