/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.io.Serializable;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class CreateMailboxFilingRootUnrestricted
extends UnrestrictedSessionRunner {
    protected final DocumentModel doc;

    public CreateMailboxFilingRootUnrestricted(CoreSession session, DocumentModel doc) {
        super(session);
        this.doc = doc;
    }

    public void run() throws ClientException {
        Mailbox mb = (Mailbox)this.doc.getAdapter(Mailbox.class);
        String filingRootName = this.getFilingRootNamePrefix() + mb.getTitle();
        String filingFolderId = IdUtils.generateId((String)filingRootName, (String)"-", (boolean)true, (int)24);
        DocumentModel filingRoot = this.session.createDocumentModel(this.doc.getPathAsString(), filingFolderId, "ClassificationRoot");
        filingRoot.setPropertyValue("dc:title", (Serializable)((Object)filingRootName));
        filingRoot = this.session.createDocument(filingRoot);
        ACP acp = filingRoot.getACP();
        ACL acl = acp.getOrCreateACL("local");
        acl.add((Object)new ACE("mailbox_" + mb.getId(), "Classify", true));
        acp.addACL(acl);
        filingRoot.setACP(acp, true);
        this.session.saveDocument(filingRoot);
    }

    protected String getFilingRootNamePrefix() {
        return "Cl - ";
    }
}

