/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;

public class DistributionListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        EventContext eventCtx = event.getContext();
        Serializable envelopeObject = eventCtx.getProperty("eventContextCase");
        if (!(envelopeObject instanceof Case)) {
            return;
        }
        Case envelope = (Case)envelopeObject;
        Map recipients = (Map)((Object)eventCtx.getProperty("eventContextParticipants"));
        if (recipients == null) {
            return;
        }
        try {
            SetEnvelopeAclUnrestricted session = new SetEnvelopeAclUnrestricted(eventCtx.getCoreSession(), envelope, recipients);
            session.runUnrestricted();
        }
        catch (Exception e) {
            throw new CaseManagementRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public static class SetEnvelopeAclUnrestricted
    extends UnrestrictedSessionRunner {
        protected final Case envelope;
        protected final Map<String, List<String>> recipients;
        protected Set<String> allMailboxIds = new HashSet<String>();
        protected List<ACE> newACEs = new LinkedList<ACE>();
        protected String confidentiality;

        public SetEnvelopeAclUnrestricted(CoreSession session, Case envelope, Map<String, List<String>> recipients) {
            super(session);
            this.envelope = envelope;
            this.recipients = recipients;
        }

        public void run() throws ClientException {
            for (Map.Entry<String, List<String>> recipient : this.recipients.entrySet()) {
                this.allMailboxIds.addAll((Collection<String>)recipient.getValue());
            }
            if (!this.allMailboxIds.isEmpty()) {
                CaseItem firstCaseItem;
                ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
                DocumentModel envelopeDoc = this.envelope.getDocument();
                if (envelopeDoc != null) {
                    docs.add(envelopeDoc);
                }
                if ((firstCaseItem = this.envelope.getFirstItem(this.session)) == null) {
                    return;
                }
                this.confidentiality = firstCaseItem.getConfidentiality();
                List items = this.envelope.getCaseItems(this.session);
                for (CaseItem item : items) {
                    DocumentModel doc = item.getDocument();
                    docs.add(doc);
                }
                this.setRightsOnCaseItems(docs);
            }
        }

        protected void setRightsOnCaseItems(List<DocumentModel> docs) throws ClientException {
            for (DocumentModel doc : docs) {
                doc = this.session.getDocument(doc.getRef());
                ACP acp = doc.getACP();
                ACL mailboxACL = acp.getOrCreateACL("mailboxes");
                List<ACE> newACE = this.getNewACEs();
                mailboxACL.addAll(newACE);
                acp.removeACL("mailboxes");
                acp.addACL(mailboxACL);
                this.session.setACP(doc.getRef(), acp, true);
            }
        }

        protected List<ACE> getNewACEs() {
            if (this.newACEs == null || this.newACEs.isEmpty()) {
                for (String mailboxId : this.allMailboxIds) {
                    this.newACEs.add(new ACE("mailbox_" + mailboxId, "ReadWrite", true));
                }
                if ("1".equals(this.confidentiality)) {
                    this.newACEs.add(new ACE("Everyone", "Read", true));
                }
            }
            return this.newACEs;
        }
    }
}

