/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event.synchronization;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.event.synchronization.AbstractSyncMailboxListener;
import org.nuxeo.cm.core.service.DefaultMailboxCreator;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.synchronization.MailboxSynchronizationConstants;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.Event;

public class MailboxCreatedListener
extends AbstractSyncMailboxListener {
    private static final Log log = LogFactory.getLog(MailboxCreatedListener.class);

    public void handleEvent(Event event) throws ClientException {
        try {
            Map properties = event.getContext().getProperties();
            String mailboxTitle = (String)properties.get("eventContextMailboxTitle");
            String directoryName = (String)properties.get("eventContextDirectoryName");
            String parentSynchronizerId = (String)properties.get("eventContextMailboxParentSynchronizerId");
            String synchronizerId = (String)properties.get("eventContextSynchronizerId");
            String owner = (String)properties.get("eventContextMailboxOwner");
            String type2 = (String)properties.get("eventContextMailboxType");
            String entryId = (String)properties.get("eventContextSynchronizerEntryId");
            DocumentModel entry = (DocumentModel)properties.get("eventContextSynchronizerEntry");
            Calendar synchronizeDate = (Calendar)properties.get("eventContextSynchronizedDate");
            CoreSession session = event.getContext().getCoreSession();
            String id = null;
            boolean isPersonal = MailboxCreatedListener.isMailboxPersonal(event);
            boolean isGeneric = MailboxCreatedListener.isMailboxGeneric(event);
            if (isPersonal) {
                DefaultMailboxCreator mbCreator = new DefaultMailboxCreator();
                id = mbCreator.getPersonalMailboxId(entry);
            } else if (isGeneric) {
                id = IdUtils.generateId((String)("group:" + entryId), (String)"-", (boolean)true, (int)24);
            } else {
                log.debug((Object)("No id generation for unknown mailbox type: " + MailboxCreatedListener.getMailboxType(event)));
            }
            DocumentModel mailboxModel = MailboxCreatedListener.getMailboxDocument(event);
            Mailbox mailbox = (Mailbox)mailboxModel.getAdapter(Mailbox.class);
            mailbox.setSynchronizeState(MailboxSynchronizationConstants.synchronisedState.synchronised.toString());
            if (synchronizerId != null && !"".equals(synchronizerId)) {
                mailbox.setSynchronizerId(synchronizerId);
            }
            if (synchronizeDate != null) {
                mailbox.setLastSyncUpdate(synchronizeDate);
            }
            if (mailboxTitle != null && !"".equals(mailboxTitle)) {
                mailbox.setTitle(mailboxTitle);
            }
            if (directoryName != null && !"".equals(directoryName)) {
                mailbox.setOrigin(directoryName);
            }
            if (owner != null && !"".equals(owner)) {
                mailbox.setOwner(owner);
            }
            if (isPersonal) {
                LinkedList<String> users = new LinkedList<String>();
                users.add(entryId);
                mailbox.setUsers(users);
            } else {
                LinkedList<String> groups = new LinkedList<String>();
                groups.add(entryId);
                mailbox.setGroups(groups);
            }
            mailbox.setType(type2);
            ArrayList<String> list = new ArrayList<String>();
            list.add("cellule_courrier");
            mailbox.setProfiles(list);
            mailbox.setId(id);
            mailboxModel.setPathInfo(this.getMailboxParentPath(session, parentSynchronizerId), this.getMailboxPathSegment(entry, mailboxModel));
            this.beforeMailboxCreation(mailbox, event);
            mailboxModel = session.createDocument(mailboxModel);
            mailbox = (Mailbox)mailboxModel.getAdapter(Mailbox.class);
            this.afterMailboxCreation(mailbox, event);
            mailbox.save(session);
        }
        catch (Exception e) {
            throw new CaseManagementException("Error during mailboxes creation", (Throwable)e);
        }
    }

    protected void beforeMailboxCreation(Mailbox mailbox, Event event) throws ClientException {
    }

    protected void afterMailboxCreation(Mailbox mailbox, Event event) throws ClientException {
    }

    protected String getMailboxParentPath(CoreSession session, String parentSynchronizerId) throws ClientException {
        String searchQuery = parentSynchronizerId == null || "".equals(parentSynchronizerId) ? String.format("SELECT * from %s", "MailboxRoot") : String.format("SELECT * from Mailbox WHERE mlbx:synchronizerId= '%s'", parentSynchronizerId);
        DocumentModelList res = session.query(searchQuery);
        if (res == null || res.isEmpty()) {
            throw new CaseManagementException("Cannot find any mailbox folder");
        }
        return ((DocumentModel)res.get(0)).getPathAsString();
    }

    protected String getMailboxPathSegment(DocumentModel dirEntry, DocumentModel mailboxModel) throws ClientException {
        return DefaultMailboxCreator.getNewMailboxPathSegment(mailboxModel);
    }
}

