/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event.synchronization;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.service.synchronization.MailboxSynchronizationService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.runtime.api.Framework;

public class MailboxSynchronizationListener
implements EventListener {
    private static final Log log = LogFactory.getLog(MailboxSynchronizationListener.class);
    public static boolean doingSync = false;

    public void handleEvent(Event event) throws ClientException {
        try {
            if (!doingSync) {
                doingSync = true;
                MailboxSynchronizationService syncService = (MailboxSynchronizationService)Framework.getService(MailboxSynchronizationService.class);
                syncService.doSynchronize();
                doingSync = false;
            } else {
                log.info((Object)"Scheduled synchronization will not run because a previous synchronization is not done yet.");
            }
        }
        catch (Exception e) {
            doingSync = false;
            throw new CaseManagementRuntimeException("Error during Mailboxes synchronization", (Throwable)e);
        }
    }
}

