/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.event.synchronization;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.event.synchronization.AbstractSyncMailboxListener;
import org.nuxeo.cm.exception.CaseManagementException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;

public class MailboxUpdatedListener
extends AbstractSyncMailboxListener {
    private static final Log log = LogFactory.getLog(MailboxUpdatedListener.class);

    public void handleEvent(Event event) throws ClientException {
        DocumentModel sourceDoc = MailboxUpdatedListener.getMailboxDocument(event);
        try {
            Mailbox mailbox = (Mailbox)sourceDoc.getAdapter(Mailbox.class);
            this.beforeMailboxUpdate(mailbox, event);
            LinkedList<String> newUsers = new LinkedList<String>();
            LinkedList<String> newGroups = new LinkedList<String>();
            Map properties = event.getContext().getProperties();
            String mailboxTitle = (String)properties.get("eventContextMailboxTitle");
            String owner = (String)properties.get("eventContextMailboxOwner");
            boolean isPersonal = MailboxUpdatedListener.isMailboxPersonal(event);
            if (owner != null && !"".equals(owner)) {
                newUsers.add(owner);
                if (isPersonal) {
                    mailbox.setOwner(owner);
                }
            }
            String entryId = (String)properties.get("eventContextSynchronizerEntryId");
            if (!isPersonal) {
                newGroups.add(entryId);
            }
            mailbox.setTitle(mailboxTitle);
            boolean doMerge = MailboxUpdatedListener.isGroupUpdatePolicy(event, MailboxConstants.updatePolicy.merge);
            boolean doOverride = MailboxUpdatedListener.isGroupUpdatePolicy(event, MailboxConstants.updatePolicy.override);
            if (doMerge) {
                if (isPersonal && !newUsers.isEmpty()) {
                    List users = mailbox.getUsers();
                    newUsers.addAll(users);
                    mailbox.setUsers(newUsers);
                } else if (!newGroups.isEmpty()) {
                    List groups = mailbox.getGroups();
                    newGroups.addAll(groups);
                    mailbox.setGroups(newGroups);
                }
            } else if (doOverride) {
                if (isPersonal && !newUsers.isEmpty()) {
                    mailbox.setUsers(newUsers);
                } else if (!newGroups.isEmpty()) {
                    mailbox.setGroups(newGroups);
                }
            } else {
                log.debug((Object)("No users or groups were changed on mailbox, unknown update policy: " + MailboxUpdatedListener.getGroupUpdatePolicy(event)));
            }
            this.beforeMailboxSave(mailbox, event);
            CoreSession coreSession = event.getContext().getCoreSession();
            mailbox.save(coreSession);
        }
        catch (Exception e) {
            throw new CaseManagementException("Error during mailboxes update", (Throwable)e);
        }
    }

    protected void beforeMailboxUpdate(Mailbox mailbox, Event event) throws ClientException {
    }

    protected void beforeMailboxSave(Mailbox mailbox, Event event) throws ClientException {
    }
}

