/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.service.CaseDistributionServiceImpl;
import org.nuxeo.cm.core.service.CreationClassDescriptor;
import org.nuxeo.cm.core.service.MailboxManagementServiceImpl;
import org.nuxeo.cm.core.service.PersisterDescriptor;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.cm.service.CaseManagementPersister;
import org.nuxeo.cm.service.MailboxCreator;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CaseManagementComponent
extends DefaultComponent {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(CaseManagementComponent.class);
    protected static final String MAILBOX_CREATOR_EXTENSION_POINT = "mailboxCreator";
    protected static final String POST_FACTORY_EXTENSION_POINT = "postFactory";
    protected static final String MESSAGE_FACTORY_EXTENSION_POINT = "messageFactory";
    protected static final String PERSISTER_EXTENSION_POINT = "persister";
    protected MailboxManagementServiceImpl mailboxService;
    protected CaseDistributionServiceImpl distributionService;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.mailboxService = new MailboxManagementServiceImpl();
        this.distributionService = new CaseDistributionServiceImpl();
        this.distributionService.setPathSegmentService((PathSegmentService)Framework.getService(PathSegmentService.class));
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(MailboxManagementService.class)) {
            return (T)this.mailboxService;
        }
        if (adapter.isAssignableFrom(CaseDistributionService.class)) {
            return (T)this.distributionService;
        }
        return null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals(MAILBOX_CREATOR_EXTENSION_POINT)) {
            CreationClassDescriptor classDesc = (CreationClassDescriptor)contribution;
            String className = classDesc.getKlass();
            Object creator = CaseManagementComponent.class.getClassLoader().loadClass(className).newInstance();
            if (creator instanceof MailboxCreator) {
                this.mailboxService.setPersonalMailboxCreator((MailboxCreator)creator);
            } else {
                log.error((Object)("Invalid contribution to personal mailbox creator: " + className));
            }
        } else if (PERSISTER_EXTENSION_POINT.equals(extensionPoint)) {
            PersisterDescriptor desc = (PersisterDescriptor)contribution;
            CaseManagementPersister persister = desc.getKlass().newInstance();
            String rootPath = desc.getCaseRootPath();
            if (rootPath != null) {
                persister.setCaseRootPath(rootPath);
            }
            this.distributionService.setPersister(persister);
        } else {
            log.warn((Object)("Unknown extension point " + extensionPoint));
        }
    }
}

