/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class CreateCaseItemUnrestricted
extends UnrestrictedSessionRunner {
    protected final DocumentModel doc;
    protected List<Mailbox> mailboxes;
    protected Case kase;
    protected DocumentRef ref;

    public CreateCaseItemUnrestricted(CoreSession session, DocumentModel doc, List<Mailbox> mailboxes) {
        super(session);
        this.doc = doc;
        this.mailboxes = mailboxes;
    }

    public CreateCaseItemUnrestricted(CoreSession session, DocumentModel doc, Case kase) {
        super(session);
        this.doc = doc;
        this.kase = kase;
    }

    public void run() throws ClientException {
        DocumentModel newDoc = this.session.createDocument(this.doc);
        newDoc.copyContent(this.doc);
        ACP acp = newDoc.getACP();
        ACL acl = acp.getOrCreateACL("mailboxes");
        this.addACL(acl);
        acp.addACL(acl);
        this.session.setACP(newDoc.getRef(), acp, true);
        this.ref = newDoc.getRef();
    }

    private void addACL(ACL acl) {
        if (this.mailboxes != null) {
            for (Mailbox mailbox : this.mailboxes) {
                acl.add((Object)new ACE("mailbox_" + mailbox.getId(), "ReadWrite", true));
            }
        } else {
            try {
                ACL aces = this.kase.getDocument().getACP().getACL("mailboxes");
                acl.addAll((Collection)(aces == null ? new ArrayList() : aces));
            }
            catch (ClientException e) {
                throw new CaseManagementRuntimeException((Throwable)e);
            }
        }
    }

    public DocumentRef getDocRef() {
        return this.ref;
    }
}

