/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.List;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.cases.CaseItem;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;

public class CreateCaseUnrestricted
extends UnrestrictedSessionRunner {
    protected final CaseItem item;
    protected final String parentPath;
    protected final List<Mailbox> mailboxes;
    protected DocumentRef ref;

    public CreateCaseUnrestricted(CoreSession session, CaseItem item, String parentPath, List<Mailbox> mailboxes) {
        super(session);
        this.item = item;
        this.parentPath = parentPath;
        this.mailboxes = mailboxes;
    }

    public void run() throws ClientException {
        Case env = this.item.createMailCase(this.session, this.parentPath, null);
        DocumentModel doc = env.getDocument();
        ACP acp = doc.getACP();
        ACL acl = acp.getOrCreateACL("mailboxes");
        for (Mailbox mailbox : this.mailboxes) {
            acl.add((Object)new ACE("mailbox_" + mailbox.getId(), "ReadWrite", true));
        }
        acp.addACL(acl);
        this.session.setACP(doc.getRef(), acp, true);
        this.ref = doc.getRef();
    }

    public DocumentRef getDocumentRef() {
        return this.ref;
    }
}

