/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.service.MailboxManagementService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.api.Framework;

public class GetMailboxesUnrestricted
extends UnrestrictedSessionRunner {
    protected List<Mailbox> mailboxes = new ArrayList<Mailbox>();
    protected final List<String> muids;

    public GetMailboxesUnrestricted(CoreSession session, List<String> muids) {
        super(session);
        this.muids = muids;
    }

    public GetMailboxesUnrestricted(CoreSession session, String muid) {
        super(session);
        ArrayList<String> muids;
        if (muid == null) {
            muids = new ArrayList<String>(0);
        } else {
            muids = new ArrayList(1);
            muids.add(muid);
        }
        this.muids = muids;
    }

    public void run() throws ClientException {
        if (this.muids == null) {
            return;
        }
        MailboxManagementService service = null;
        try {
            service = (MailboxManagementService)Framework.getService(MailboxManagementService.class);
        }
        catch (ClientException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        if (service == null) {
            throw new ClientException("MailboxManagementService not found");
        }
        this.mailboxes = service.getMailboxes(this.session, this.muids);
    }

    public List<Mailbox> getMailboxes() {
        return this.mailboxes;
    }
}

