/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailboxConstants;
import org.nuxeo.cm.service.CaseManagementDocumentTypeService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.runtime.api.Framework;

public class SearchMailboxesUnrestricted
extends UnrestrictedSessionRunner {
    private static final Log log = LogFactory.getLog(SearchMailboxesUnrestricted.class);
    protected List<Mailbox> mailboxes;
    protected final String pattern;
    protected final String type;

    public SearchMailboxesUnrestricted(CoreSession session, String pattern, String type2) {
        super(session);
        this.pattern = pattern;
        this.type = type2;
    }

    public void run() throws ClientException {
        try {
            DocumentModelList res = this.queryMailboxes();
            this.mailboxes = MailboxConstants.getMailboxList((List)res);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected DocumentModelList queryMailboxes() throws ClientException {
        String query = String.format("SELECT * FROM %s WHERE %s ILIKE '%%%s%%' AND ecm:currentLifeCycleState != '%s'", this.getMailboxType(), "dc:title", this.pattern, "deleted");
        if (this.type != null) {
            query = query + String.format(" AND %s='%s'", "mlbx:type", this.type);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)query);
        }
        return this.session.query(query);
    }

    public List<Mailbox> getMailboxes() {
        return this.mailboxes;
    }

    private String getMailboxType() throws ClientException {
        CaseManagementDocumentTypeService correspDocumentTypeService;
        try {
            correspDocumentTypeService = (CaseManagementDocumentTypeService)Framework.getService(CaseManagementDocumentTypeService.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return correspDocumentTypeService.getMailboxType();
    }
}

