/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter;

import java.util.List;
import org.nuxeo.cm.cases.Case;
import org.nuxeo.cm.core.service.caseimporter.sourcenodes.CaseSourceNode;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.GenericThreadedImportTask;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class CaseImporterThreadedTask
extends GenericThreadedImportTask {
    CaseDistributionService distributionService;

    public CaseImporterThreadedTask(CoreSession session) {
        super(session);
    }

    protected DocumentModel doCreateFolderishNode(DocumentModel parent, SourceNode node) throws Exception {
        if (!this.shouldImportDocument(node)) {
            return null;
        }
        DocumentModel folder = this.getFactory().createFolderishNode(this.getCoreSession(), parent, node);
        if (folder != null) {
            String parentPath = parent == null ? "null" : parent.getPathAsString();
            this.fslog("Created Folder " + folder.getName() + " at " + parentPath, true);
        }
        return folder;
    }

    protected DocumentModel doCreateLeafNode(DocumentModel parent, SourceNode node) throws Exception {
        if (!this.shouldImportDocument(node)) {
            return null;
        }
        DocumentModel leaf = this.getFactory().createLeafNode(this.getCoreSession(), parent, node);
        if (leaf != null && node.getBlobHolder() != null) {
            long fileSize = node.getBlobHolder().getBlob().getLength();
            String fileName = node.getBlobHolder().getBlob().getFilename();
            if (fileSize > 0L) {
                long kbSize = fileSize / 1024L;
                String parentPath = parent == null ? "null" : parent.getPathAsString();
                this.fslog("Created doc " + leaf.getName() + " at " + parentPath + " with file " + fileName + " of size " + kbSize + "KB", true);
            }
            this.uploadedKO += fileSize;
        }
        return leaf;
    }

    protected void recursiveCreateDocumentFromNode(DocumentModel parent, SourceNode node) throws Exception {
        if (this.getFactory().isTargetDocumentModelFolderish(node)) {
            DocumentModel folder;
            Boolean newThread = false;
            if (this.skipContainerCreation.booleanValue()) {
                folder = parent;
                this.skipContainerCreation = false;
                newThread = true;
            } else {
                folder = this.doCreateFolderishNode(parent, node);
                if (folder == null) {
                    return;
                }
            }
            List nodes = node.getChildren();
            if (nodes != null && nodes.size() > 0) {
                GenericThreadedImportTask task = null;
                if (!newThread.booleanValue()) {
                    task = this.createNewTaskIfNeeded(folder, node);
                }
                if (task != null) {
                    this.commit(true);
                    GenericMultiThreadedImporter.getExecutor().execute((Runnable)task);
                } else {
                    for (SourceNode child : nodes) {
                        this.recursiveCreateDocumentFromNode(folder, child);
                    }
                }
                if (node instanceof CaseSourceNode) {
                    this.distributeCase(folder, (CaseSourceNode)node);
                }
            }
        } else {
            this.doCreateLeafNode(parent, node);
        }
    }

    protected void distributeCase(DocumentModel caseDoc, CaseSourceNode node) throws Exception {
        Case kase = (Case)caseDoc.getAdapter(Case.class);
        this.getCaseDistributionService().sendCase(this.session, "Import", kase, node.getDistributionInfo());
    }

    private CaseDistributionService getCaseDistributionService() throws Exception {
        if (this.distributionService == null) {
            this.distributionService = (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        }
        return this.distributionService;
    }
}

