/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter;

import org.nuxeo.cm.core.service.caseimporter.CaseImporter;
import org.nuxeo.cm.core.service.caseimporter.CaseManagementCaseImporterDescriptor;
import org.nuxeo.cm.service.caseimporter.AbstractXMLCaseReader;
import org.nuxeo.cm.service.caseimporter.CaseManagementCaseImporterService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CaseManagementCaseImporterServiceImpl
extends DefaultComponent
implements CaseManagementCaseImporterService {
    private static final long serialVersionUID = 1L;
    private AbstractXMLCaseReader xmlCaseReader;
    protected int noImportingThreads = 5;

    public void importCases(String sourcePath) throws ClientException {
        CaseImporter importer = new CaseImporter(this.noImportingThreads, this.xmlCaseReader);
        try {
            importer.importDocuments(sourcePath);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("importer".equals(extensionPoint)) {
            CaseManagementCaseImporterDescriptor caseImporterDescriptor = (CaseManagementCaseImporterDescriptor)contribution;
            if (caseImporterDescriptor.caseReader != null) {
                this.xmlCaseReader = caseImporterDescriptor.caseReader.newInstance();
            }
            if (caseImporterDescriptor.noImportingThreads != null) {
                this.noImportingThreads = Integer.parseInt(caseImporterDescriptor.noImportingThreads);
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        this.xmlCaseReader = null;
    }
}

