/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;
import org.nuxeo.cm.distribution.CMFDistributionInfo;
import org.nuxeo.cm.distribution.DistributionInfo;
import org.nuxeo.cm.service.caseimporter.AbstractXMLCaseReader;
import org.nuxeo.ecm.core.api.ClientException;

public class DefaultXMLCaseReader
extends AbstractXMLCaseReader {
    public static final Log log = LogFactory.getLog(DefaultXMLCaseReader.class);
    public static final String ALL_CASES_TAG = "cases";
    public static final String CASE_TAG = "document";
    public static final String CASE_ITEMS = "caseItems";
    public static final String CASE_ITEM_DOCUMENT_PATH = "path";
    public static final String CASE_RECIPIENTS_TAG = "recipients";
    public static final String CASE_RECIPIENTS_ACTION = "action";
    public static final String CASE_RECIPIENTS_INFORMATION = "information";
    public static final String CASE_RECIPIENTS_MAILBOX_TAG = "mailbox";

    public List<Document> loadCases(File file) throws ClientException {
        return this.readDomDoc(this.loadXML(file));
    }

    protected Document loadXML(File file) throws ClientException {
        BufferedInputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            Document document = new SAXReader().read((InputStream)in);
            return document;
        }
        catch (Exception e) {
            log.error((Object)("Failed to read document from file " + file.getAbsolutePath()));
            throw new ClientException();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    in = null;
                }
            }
        }
    }

    private List<Document> readDomDoc(Document doc) throws ClientException {
        XPath xpathSelector = DocumentHelper.createXPath((String)"/cases/document");
        List allCases = xpathSelector.selectNodes((Object)doc);
        ArrayList<Document> caseReaders = new ArrayList<Document>();
        for (Element element : allCases) {
            caseReaders.add(this.extractEntireCase(element));
        }
        return caseReaders;
    }

    public List<Element> loadCaseItems(Element caseElement) {
        return caseElement.element(CASE_ITEMS).elements(CASE_ITEM_DOCUMENT_PATH);
    }

    public String getCaseItemPathFile(Element caseItemElement) {
        return (String)caseItemElement.getData();
    }

    public DistributionInfo getDistributionInfo(Element caseElement) {
        ArrayList<String> actionMailboxes = new ArrayList<String>();
        ArrayList<String> informationMailboxes = new ArrayList<String>();
        CMFDistributionInfo distributionInfo = new CMFDistributionInfo();
        Element allRecipients = caseElement.element(CASE_RECIPIENTS_TAG);
        if (allRecipients != null) {
            List actionMailboxesElements = allRecipients.element(CASE_RECIPIENTS_ACTION).elements(CASE_RECIPIENTS_MAILBOX_TAG);
            for (Element element : actionMailboxesElements) {
                actionMailboxes.add((String)element.getData());
            }
            List informationMailboxesElements = caseElement.element(CASE_RECIPIENTS_TAG).element(CASE_RECIPIENTS_INFORMATION).elements(CASE_RECIPIENTS_MAILBOX_TAG);
            for (Element element : informationMailboxesElements) {
                informationMailboxes.add((String)element.getData());
            }
        }
        distributionInfo.setForActionMailboxes(actionMailboxes);
        distributionInfo.setForInformationMailboxes(informationMailboxes);
        return distributionInfo;
    }
}

