/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.caseimporter.sourcenodes;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.nuxeo.cm.core.service.caseimporter.sourcenodes.CaseSourceNode;
import org.nuxeo.cm.service.caseimporter.AbstractXMLCaseReader;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.importer.source.FileSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class CaseManagementSourceNode
extends FileSourceNode {
    public static final Log log = LogFactory.getLog(CaseManagementSourceNode.class);
    private AbstractXMLCaseReader xmlCaseReader;
    private List<Document> allCases = new ArrayList<Document>();

    public CaseManagementSourceNode(File child, AbstractXMLCaseReader xmlCaseReader) {
        super(child);
        this.xmlCaseReader = xmlCaseReader;
    }

    public List<SourceNode> getChildren() {
        ArrayList<SourceNode> cases = new ArrayList<SourceNode>();
        try {
            this.allCases = this.xmlCaseReader.loadCases(this.file);
        }
        catch (ClientException e) {
            log.error((Object)"Can not fetch cases");
        }
        for (Document el : this.allCases) {
            cases.add(new CaseSourceNode(el.getRootElement(), this.xmlCaseReader, this.file.getPath()));
        }
        return cases;
    }

    public boolean isFolderish() {
        return this.getChildren().size() > 0;
    }
}

