/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.core.service.importer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.core.service.importer.CaseManagementCaseItemDocumentFactory;
import org.nuxeo.cm.core.service.importer.CaseManagementImporter;
import org.nuxeo.cm.core.service.importer.CaseManagementImporterDescriptor;
import org.nuxeo.cm.exception.CaseManagementRuntimeException;
import org.nuxeo.cm.service.CaseManagementImporterService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CaseManagementImporterServiceImpl
extends DefaultComponent
implements CaseManagementImporterService {
    private static final Log log = LogFactory.getLog(CaseManagementImporterServiceImpl.class);
    private static final long serialVersionUID = 4984067871511405259L;
    CaseManagementImporterDescriptor importInfo;
    private String destionationMailboxPath;
    private String noImportingThreads;
    private Class<CaseManagementCaseItemDocumentFactory> importerDocumentModelfactoryClass;
    private String folderPath;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        this.importInfo = (CaseManagementImporterDescriptor)contribution;
        if (this.importInfo.destionationMailboxPath != null) {
            this.destionationMailboxPath = this.importInfo.destionationMailboxPath;
        }
        if (this.importInfo.noImportingThreads != null) {
            this.noImportingThreads = this.importInfo.noImportingThreads;
        }
        if (this.importInfo.importerDocumentModelfactoryClass != null) {
            this.importerDocumentModelfactoryClass = this.importInfo.importerDocumentModelfactoryClass;
        }
        if (this.importInfo.folderPath != null) {
            this.folderPath = this.importInfo.folderPath;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.destionationMailboxPath = null;
        this.noImportingThreads = null;
        this.importerDocumentModelfactoryClass = null;
        this.importInfo = null;
    }

    public void importDocuments() {
        if (!this.importerConfigured()) {
            log.warn((Object)"No there is no importer configured!");
            return;
        }
        new CaseManagementImporter(this.destionationMailboxPath, this.noImportingThreads, this.folderPath, this.getImporterDocumentModelFactory()).importDocuments();
    }

    public final CaseManagementCaseItemDocumentFactory getImporterDocumentModelFactory() {
        try {
            return this.importerDocumentModelfactoryClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new CaseManagementRuntimeException((Throwable)e);
        }
    }

    private boolean importerConfigured() {
        return this.importInfo != null;
    }
}

