/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.classification;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ValueChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.classification.api.ClassificationHelper;
import org.nuxeo.ecm.classification.api.ClassificationService;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.impl.UserPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.classification.ClassificationActions;
import org.nuxeo.ecm.platform.classification.ClassificationTreeNode;
import org.nuxeo.ecm.platform.classification.PagedClassificationsProvider;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelImpl;
import org.nuxeo.ecm.platform.ui.web.pagination.ResultsProviderFarmUserException;
import org.nuxeo.ecm.webapp.action.TypesTool;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;

@Name(value="classificationActions")
@Scope(value=ScopeType.CONVERSATION)
public class ClassificationActionsBean
implements ClassificationActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(ClassificationActionsBean.class);
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In
    protected transient Context eventContext;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true)
    private transient NavigationContext navigationContext;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient QueryModelActions queryModelActions;
    @In(create=true)
    private transient ResultsProvidersCache resultsProvidersCache;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected TypesTool typesTool;
    protected DocumentModelList currentDocumentClassifications;
    protected DocumentModelList classificationRoots;
    protected DocumentModel currentClassificationRoot;
    protected DocumentTreeNode currentClassificationTree;
    protected DocumentModelList editableClassificationRoots;
    protected DocumentModel currentEditableClassificationRoot;
    protected DocumentTreeNode currentEditableClassificationTree;
    protected String currentSelectionViewId;
    public static final String DOCUMENTS_PAGE_SIZE_PROPERTY_NAME = "classification.documents.pageSize";

    protected List<DocumentModel> getFilteredSelectedDocumentsForClassification() throws ClientException {
        ClassificationService clService;
        try {
            clService = (ClassificationService)Framework.getService(ClassificationService.class);
        }
        catch (Exception e) {
            throw new ClientException("Could not find Classification Service", (Throwable)e);
        }
        DocumentModelListImpl filtered = new DocumentModelListImpl();
        List docs = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (docs != null) {
            for (DocumentModel doc : docs) {
                if (doc == null || !clService.isClassifiable(doc)) continue;
                filtered.add(doc);
            }
        }
        return filtered;
    }

    @Override
    public boolean getCanClassifyFromCurrentSelection() throws ClientException {
        List<DocumentModel> classifiable = this.getFilteredSelectedDocumentsForClassification();
        return !classifiable.isEmpty();
    }

    @Override
    public Collection<DocumentModel> getTargetDocuments() throws ClientException {
        ArrayList<DocumentModel> res = new ArrayList<DocumentModel>();
        res.add(this.navigationContext.getCurrentDocument());
        return res;
    }

    @Override
    public String classify(ClassificationTreeNode node) throws ClientException {
        Collection<DocumentModel> targetDocs = this.getTargetDocuments();
        if (node != null) {
            this.classify(targetDocs, node.getDocument());
            node.resetChildren();
        }
        return null;
    }

    @Override
    public Collection<DocumentModel> getMassTargetDocuments() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION_FOR_CLASSIFICATION")) {
            return this.documentsListsManager.getWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION");
        }
        log.debug((Object)"No documents selection in context to process classification on");
        return null;
    }

    @Override
    public String massClassify(ClassificationTreeNode node) throws ClientException {
        Collection<DocumentModel> targetDocs = this.getMassTargetDocuments();
        if (node != null && targetDocs != null) {
            this.classify(targetDocs, node.getDocument());
            node.resetChildren();
        }
        return null;
    }

    @Override
    public boolean classify(Collection<DocumentModel> targetDocs, DocumentModel classificationFolder) throws ClientException {
        ClassificationService clService;
        if (targetDocs.isEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.classification.noDocumentsToClassify"), new Object[0]);
            return true;
        }
        if (classificationFolder == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.classification.noClassificationFolder"), new Object[0]);
            return true;
        }
        if (!classificationFolder.hasSchema("classification")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.classification.invalidClassificationFolder"), new Object[0]);
            return true;
        }
        DocumentRef classificationRef = classificationFolder.getRef();
        if (!this.documentManager.hasPermission(classificationRef, "Classify")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.classification.unauthorized"), new Object[0]);
            return true;
        }
        ArrayList<String> targets = (ArrayList<String>)classificationFolder.getPropertyValue("classification:targets");
        if (targets == null) {
            targets = new ArrayList<String>();
        }
        String targetNotificationComment = String.format("%s:%s", this.documentManager.getRepositoryName(), classificationRef.toString());
        boolean alreadyClassified = false;
        boolean invalid = false;
        try {
            clService = (ClassificationService)Framework.getService(ClassificationService.class);
        }
        catch (Exception e) {
            throw new ClientException("Could not find Classification Service", (Throwable)e);
        }
        for (DocumentModel targetDoc : targetDocs) {
            if (targetDoc == null) continue;
            if (!clService.isClassifiable(targetDoc)) {
                invalid = true;
                continue;
            }
            String targetDocId = targetDoc.getId();
            if (targets.contains(targetDocId)) {
                alreadyClassified = true;
                continue;
            }
            targets.add(targetDocId);
            String comment = String.format("%s:%s", this.documentManager.getRepositoryName(), targetDocId);
            this.notifyEvent(this.documentManager, "ClassificationDone", classificationFolder, null, comment, null, null);
            this.notifyEvent(this.documentManager, "ClassificationDone", targetDoc, null, targetNotificationComment, null, null);
        }
        classificationFolder.setPropertyValue("classification:targets", targets);
        this.documentManager.saveDocument(classificationFolder);
        this.documentManager.save();
        Events.instance().raiseEvent("historyChanged", new Object[0]);
        if (invalid && alreadyClassified) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.classification.requestDoneButSomeWereAlreadyClassifiedAndSomeInvalid"), new Object[0]);
        } else if (invalid) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.classification.requestDoneButSomeInvalid"), new Object[0]);
        } else if (alreadyClassified) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.classification.requestDoneButSomeWereAlreadyClassified"), new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.classification.requestDone"), new Object[0]);
        }
        return false;
    }

    @Override
    public String cancelClassification() throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        return this.navigationContext.navigateToDocument(currentDoc);
    }

    @Override
    public String getCurrentClassificationRootId() throws ClientException {
        DocumentModel root = this.getCurrentClassificationRoot();
        if (root != null) {
            return root.getId();
        }
        return null;
    }

    @Override
    public void setCurrentClassificationRootId(String newRootId) throws ClientException {
        if (newRootId != null) {
            DocumentModelList roots = this.getClassificationRoots();
            for (DocumentModel root : roots) {
                if (!newRootId.equals(root.getId())) continue;
                this.currentClassificationRoot = root;
                break;
            }
            this.currentClassificationTree = null;
            this.eventContext.remove("currentClassificationTree");
        }
    }

    @Override
    public String navigateToCurrentClassificationRoot() throws ClientException {
        return this.navigationContext.navigateToDocument(this.currentClassificationRoot);
    }

    @Override
    public DocumentModel getCurrentClassificationRoot() throws ClientException {
        DocumentModelList roots = this.getClassificationRoots();
        if (!roots.contains((Object)this.currentClassificationRoot)) {
            this.currentClassificationRoot = null;
            this.currentClassificationTree = null;
        }
        if (this.currentClassificationRoot == null && !roots.isEmpty()) {
            this.currentClassificationRoot = (DocumentModel)roots.get(0);
        }
        return this.currentClassificationRoot;
    }

    @Override
    @Factory(value="currentEditableClassificationRootId", scope=ScopeType.EVENT)
    public String getCurrentEditableClassificationRootId() throws ClientException {
        DocumentModel root = this.getCurrentEditableClassificationRoot();
        if (root != null) {
            return root.getId();
        }
        return null;
    }

    @Override
    public void setCurrentEditableClassificationRootId(String newRootId) throws ClientException {
        if (newRootId != null) {
            DocumentModelList roots = this.getEditableClassificationRoots();
            for (DocumentModel root : roots) {
                if (!newRootId.equals(root.getId())) continue;
                this.currentEditableClassificationRoot = root;
                break;
            }
            this.currentEditableClassificationTree = null;
            this.eventContext.remove("currentEditableClassificationTree");
        }
    }

    @Override
    public DocumentModel getCurrentEditableClassificationRoot() throws ClientException {
        DocumentModelList roots;
        if (this.currentEditableClassificationRoot == null && !(roots = this.getEditableClassificationRoots()).isEmpty()) {
            this.currentEditableClassificationRoot = (DocumentModel)roots.get(0);
        }
        return this.currentEditableClassificationRoot;
    }

    @Override
    @Factory(value="currentClassificationTree", scope=ScopeType.EVENT)
    public DocumentTreeNode getCurrentClassificationTree() throws ClientException {
        DocumentModel root;
        if (this.currentClassificationTree == null && (root = this.getCurrentClassificationRoot()) != null) {
            Filter filter = null;
            Sorter sorter = null;
            try {
                TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                filter = treeManager.getFilter("classification");
                sorter = treeManager.getSorter("classification");
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            this.currentClassificationTree = new DocumentTreeNodeImpl(this.documentManager.getSessionId(), root, filter, sorter);
        }
        return this.currentClassificationTree;
    }

    @Override
    @Factory(value="currentEditableClassificationTree", scope=ScopeType.EVENT)
    public DocumentTreeNode getCurrentEditableClassificationTree() throws ClientException {
        DocumentModel root;
        if (this.currentEditableClassificationTree == null && (root = this.getCurrentEditableClassificationRoot()) != null) {
            Filter filter = null;
            Sorter sorter = null;
            try {
                TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                filter = treeManager.getFilter("classification");
                sorter = treeManager.getSorter("classification");
            }
            catch (Exception e) {
                log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
            }
            this.currentEditableClassificationTree = new ClassificationTreeNode(root, filter, sorter);
        }
        return this.currentEditableClassificationTree;
    }

    @Override
    @Factory(value="classificationRoots", scope=ScopeType.EVENT)
    public DocumentModelList getClassificationRoots() throws ClientException {
        if (this.classificationRoots == null) {
            this.classificationRoots = new DocumentModelListImpl();
            try {
                PagedDocumentsProvider provider = this.getResultsProvider("CLASSIFICATION_ROOTS");
                DocumentModelList resultDocuments = provider.getCurrentPage();
                for (DocumentModel doc : resultDocuments) {
                    this.classificationRoots.add((Object)this.documentManager.getDocument(doc.getRef()));
                }
            }
            catch (ResultsProviderFarmUserException e) {
                log.error((Object)e);
            }
            catch (ClientException e) {
                log.error((Object)e);
            }
        }
        return this.classificationRoots;
    }

    @Override
    @Factory(value="editableClassificationRoots", scope=ScopeType.EVENT)
    public DocumentModelList getEditableClassificationRoots() throws ClientException {
        if (this.editableClassificationRoots == null) {
            this.editableClassificationRoots = new DocumentModelListImpl();
            for (DocumentModel classificationRoot : this.getClassificationRoots()) {
                DocumentRef rootRef = classificationRoot.getRef();
                if (!this.documentManager.hasPermission(rootRef, "Classify")) continue;
                this.editableClassificationRoots.add((Object)this.documentManager.getDocument(rootRef));
            }
        }
        return this.editableClassificationRoots;
    }

    @Override
    public void editableClassificationRootSelected(ValueChangeEvent event) throws ClientException {
        Object newValue = event.getNewValue();
        if (newValue instanceof String) {
            String newRootId = (String)newValue;
            this.setCurrentEditableClassificationRootId(newRootId);
        }
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentChanged", "documentSecurityChanged", "documentChildrenChanged"}, create=false)
    public void resetClassificationData() {
        this.classificationRoots = null;
        this.currentClassificationTree = null;
        this.editableClassificationRoots = null;
        this.currentEditableClassificationRoot = null;
        this.currentEditableClassificationTree = null;
        this.resultsProvidersCache.invalidate("CLASSIFICATION_ROOTS");
        this.resetCurrentDocumentClassifications();
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentSelectionChanged"}, create=false)
    public void resetCurrentDocumentClassifications() {
        this.currentDocumentClassifications = null;
        this.resultsProvidersCache.invalidate("CURRENT_DOCUMENT_CLASSIFICATIONS");
        this.documentsListsManager.resetWorkingList("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION");
    }

    @Override
    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException, ResultsProviderFarmUserException {
        PagedDocumentsProvider provider;
        int pageSize = ClassificationActionsBean.getDocumentBatchSize();
        if ("CLASSIFICATION_ROOTS".equals(name)) {
            Object[] params = null;
            try {
                provider = this.getQmDocuments(name, params, sortInfo);
            }
            catch (Exception e) {
                log.error((Object)"sorted query failed");
                log.debug((Object)e);
                log.error((Object)"retrying without sort parameters");
                provider = this.getQmDocuments(name, params, null);
            }
            provider.setName(name);
        } else if ("CURRENT_DOCUMENT_CLASSIFICATIONS".equals(name)) {
            provider = new PagedClassificationsProvider((List<DocumentModel>)this.getCurrentDocumentClassifications(), pageSize, name, sortInfo);
        } else {
            if ("CURRENT_SELECTION_FOR_CLASSIFICATION_PROVIDER".equals(name)) {
                try {
                    List<DocumentModel> docs = this.getFilteredSelectedDocumentsForClassification();
                    this.documentsListsManager.resetWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION");
                    this.documentsListsManager.addToWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION", docs);
                    return new PagedClassificationsProvider(docs, pageSize, name, sortInfo);
                }
                catch (Exception e) {
                    throw new ClientException((Throwable)e);
                }
            }
            throw new ClientException("Unknown board: " + name);
        }
        return provider;
    }

    protected PagedDocumentsProvider getQmDocuments(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        return this.queryModelActions.get(qmName).getResultsProvider(this.documentManager, params, sortInfo);
    }

    @Override
    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException, ResultsProviderFarmUserException {
        return this.getResultsProvider(name, null);
    }

    @Override
    @Factory(value="currentDocumentClassifications", scope=ScopeType.EVENT)
    public DocumentModelList getCurrentDocumentClassifications() throws ClientException {
        if (this.currentDocumentClassifications == null) {
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.currentDocumentClassifications = ClassificationHelper.getClassifiedDocuments((DocumentModel)currentDocument, (CoreSession)this.documentManager);
        }
        return this.currentDocumentClassifications;
    }

    @Override
    @Factory(value="currentDocumentClassificationsSelection", scope=ScopeType.EVENT)
    public SelectDataModel getCurrentDocumentClassificationsSelection() throws ClientException {
        DocumentModelList documents = this.resultsProvidersCache.get("CURRENT_DOCUMENT_CLASSIFICATIONS").getCurrentPage();
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION");
        SelectDataModelImpl model = new SelectDataModelImpl("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION", (List)documents, selectedDocuments);
        return model;
    }

    @Override
    public String showCurrentSelectionClassificationForm(String currentViewId) throws ClientException {
        this.resultsProvidersCache.invalidate("CURRENT_SELECTION_FOR_CLASSIFICATION_PROVIDER");
        this.currentSelectionViewId = currentViewId;
        return "current_selection_classification_request";
    }

    @Override
    public String cancelCurrentSelectionClassificationForm() throws ClientException {
        if ("/search/search_results_simple.xhtml".equals(this.currentSelectionViewId)) {
            return "search_results_simple";
        }
        if ("/search/search_results_advanced.xhtml".equals(this.currentSelectionViewId)) {
            return "search_results_advanced";
        }
        if ("/search/dynsearch_results.xhtml".equals(this.currentSelectionViewId)) {
            return "dynsearch_results";
        }
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if (currentDoc != null) {
            this.navigationContext.navigateToDocument(currentDoc);
        }
        return null;
    }

    @Override
    @Factory(value="currentSelectionEmailsSelection", scope=ScopeType.EVENT)
    public SelectDataModel getCurrentSelectionEmailsSelection() throws ClientException {
        DocumentModelList docs = this.resultsProvidersCache.get("CURRENT_SELECTION_FOR_CLASSIFICATION_PROVIDER").getCurrentPage();
        List selectedDocuments = this.documentsListsManager.getWorkingList("CURRENT_SELECTION_FOR_CLASSIFICATION");
        SelectDataModelImpl model = new SelectDataModelImpl("CURRENT_SELECTION_FOR_CLASSIFICATION", (List)docs, selectedDocuments);
        return model;
    }

    @Override
    public void unclassify() throws ClientException {
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION")) {
            List toDel = this.documentsListsManager.getWorkingList("CURRENT_DOCUMENT_CLASSIFICATIONS_SELECTION");
            ArrayList<String> targetDocIds = new ArrayList<String>();
            for (DocumentModel doc : toDel) {
                targetDocIds.add(doc.getId());
            }
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            this.unclassify(targetDocIds, currentDocument);
            this.resetCurrentDocumentClassifications();
        } else {
            log.debug((Object)"No documents selection in context to process unclassify on...");
        }
    }

    protected void notifyEvent(CoreSession coreSession, String eventId, DocumentModel source, String category, String comment, String author, Map<String, Serializable> options) throws ClientException {
        if (category == null) {
            category = "eventDocumentCategory";
        }
        if (options == null) {
            options = new HashMap<String, Serializable>();
        }
        options.put("repositoryName", (Serializable)((Object)coreSession.getRepositoryName()));
        if (source != null) {
            String currentLifeCycleState = null;
            try {
                currentLifeCycleState = source.getCurrentLifeCycleState();
            }
            catch (ClientException err) {
                // empty catch block
            }
            options.put("documentLifeCycle", (Serializable)((Object)currentLifeCycleState));
        }
        options.put("sessionId", (Serializable)((Object)coreSession.getSessionId()));
        Principal principal = author != null ? new UserPrincipal(author) : coreSession.getPrincipal();
        DocumentEventContext ctx = new DocumentEventContext(coreSession, principal, source);
        ctx.setCategory(category);
        ctx.setComment(comment);
        ctx.setProperties(options);
        Event event = ctx.newEvent(eventId);
        try {
            EventProducer evtProducer = (EventProducer)Framework.getService(EventProducer.class);
            log.debug((Object)("Notify RepositoryEventListener listeners list for event=" + eventId));
            evtProducer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"Impossible to notify core events ! EventProducer service is missing...");
        }
    }

    @Override
    public boolean unclassify(Collection<String> targetDocIds, DocumentModel classificationFolder) throws ClientException {
        if (targetDocIds.isEmpty()) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.unclassification.noDocumentsToUnclassify"), new Object[0]);
            return true;
        }
        if (classificationFolder == null) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.classification.noClassificationFolder"), new Object[0]);
            return true;
        }
        if (!classificationFolder.hasSchema("classification")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.classification.invalidClassificationFolder"), new Object[0]);
            return true;
        }
        DocumentRef classificationRef = classificationFolder.getRef();
        if (!this.documentManager.hasPermission(classificationRef, "Classify")) {
            this.facesMessages.add(StatusMessage.Severity.ERROR, (String)this.resourcesAccessor.getMessages().get("feedback.unclassification.unauthorized"), new Object[0]);
            return true;
        }
        ArrayList targets = (ArrayList)classificationFolder.getPropertyValue("classification:targets");
        if (targets == null) {
            targets = new ArrayList();
        }
        String targetNotificationComment = String.format("%s:%s", this.documentManager.getRepositoryName(), classificationRef.toString());
        boolean notClassified = false;
        for (String targetDocId : targetDocIds) {
            if (targets.contains(targetDocId)) {
                targets.remove(targetDocId);
                String comment = String.format("%s:%s", this.documentManager.getRepositoryName(), targetDocId);
                this.notifyEvent(this.documentManager, "UnclassificationDone", classificationFolder, null, comment, null, null);
                DocumentModel targetDoc = this.documentManager.getDocument((DocumentRef)new IdRef(targetDocId));
                if (targetDoc == null) continue;
                this.notifyEvent(this.documentManager, "UnclassificationDone", targetDoc, null, targetNotificationComment, null, null);
                continue;
            }
            notClassified = true;
        }
        classificationFolder.setPropertyValue("classification:targets", targets);
        this.documentManager.saveDocument(classificationFolder);
        this.documentManager.save();
        Events.instance().raiseEvent("historyChanged", new Object[0]);
        if (notClassified) {
            this.facesMessages.add(StatusMessage.Severity.WARN, (String)this.resourcesAccessor.getMessages().get("feedback.unclassification.requestDoneButSomeWereNotClassified"), new Object[0]);
        } else {
            this.facesMessages.add(StatusMessage.Severity.INFO, (String)this.resourcesAccessor.getMessages().get("feedback.unclassification.requestDone"), new Object[0]);
        }
        return false;
    }

    public static int getDocumentBatchSize() {
        int pageSize = 20;
        String propsBatchSize = Framework.getProperty((String)DOCUMENTS_PAGE_SIZE_PROPERTY_NAME);
        if (propsBatchSize != null && propsBatchSize.length() > 0) {
            pageSize = Integer.parseInt(propsBatchSize);
        } else {
            log.debug((Object)String.format("Property '%s' not set: using default page size for documents providers", DOCUMENTS_PAGE_SIZE_PROPERTY_NAME));
        }
        return pageSize;
    }
}

