/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.web.mailbox;

import java.util.List;
import java.util.UUID;
import javax.faces.application.FacesMessage;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.cm.mailbox.Mailbox;
import org.nuxeo.cm.mailbox.MailingList;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBound;
import org.nuxeo.cm.web.invalidations.CaseManagementContextBoundInstance;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;

@Name(value="mailingListActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
@CaseManagementContextBound
public class MailboxMailingListBean
extends CaseManagementContextBoundInstance {
    private static final long serialVersionUID = 1L;
    public static final int MAXIMUM_MAIL_LIST_SIZE = 255;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @In(create=true, required=false)
    protected FacesMessages facesMessages;
    @In(create=true)
    protected NavigationContext navigationContext;
    protected String newTitle;
    protected MailingList currentMailingList;

    protected int getMaximumMailingListNameSize() {
        return 255;
    }

    public String createMailingList() throws ClientException {
        if (this.newTitle.length() > this.getMaximumMailingListNameSize()) {
            Object[] params = new Object[]{this.getMaximumMailingListNameSize()};
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)((String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.maximum.length")), (Object[])params);
            this.facesMessages.add(message);
            return null;
        }
        if (this.newTitle.length() == 0 || this.newTitle.equals("")) {
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)((String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.name.empty")), (Object[])new Object[0]);
            this.facesMessages.add(message);
            return null;
        }
        List existingMls = this.getCurrentMailbox().getMailingLists();
        for (MailingList mailingList : existingMls) {
            if (!this.newTitle.equals(mailingList.getTitle())) continue;
            Object[] params = new Object[]{this.newTitle};
            this.facesMessages.add(FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.create.duplicateName"), params);
            this.facesMessages.addToControl("newMlTitle", FacesMessage.SEVERITY_WARN, (String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.create.duplicateName"), params);
            this.newTitle = null;
            return null;
        }
        this.currentMailingList = this.getCurrentMailbox().getMailingListTemplate();
        this.currentMailingList.setTitle(this.newTitle);
        this.currentMailingList.setId(UUID.randomUUID().toString());
        this.getCurrentMailbox().addMailingList(this.currentMailingList);
        this.getCurrentMailbox().save(this.documentManager);
        this.newTitle = null;
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.create.success"), new Object[0]);
        return null;
    }

    public MailingList getCurrentMailingList() throws ClientException {
        List mls;
        if (this.currentMailingList == null && (mls = this.getCurrentMailbox().getMailingLists()) != null && !mls.isEmpty()) {
            this.currentMailingList = (MailingList)mls.get(0);
        }
        return this.currentMailingList;
    }

    public String deleteMailingList(String mailingListId) throws ClientException {
        this.getCurrentMailbox().removeMailingList(mailingListId);
        this.getCurrentMailbox().save(this.documentManager);
        this.newTitle = null;
        this.currentMailingList = null;
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.list.deleted"), new Object[0]);
        return null;
    }

    public String selectMailingList(String mlid) throws ClientException {
        List mls = this.getCurrentMailbox().getMailingLists();
        if (mls == null) {
            return null;
        }
        if (mlid != null) {
            for (MailingList ml : mls) {
                if (!mlid.equals(ml.getId())) continue;
                this.currentMailingList = ml;
                break;
            }
        }
        return null;
    }

    public void updateCurrentMailingList() throws ClientException {
        Mailbox mailbox = this.getCurrentMailbox().updateMailingList(this.currentMailingList);
        mailbox.save(this.documentManager);
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, (String)this.resourcesAccessor.getMessages().get("feedback.mailinglist.list.saved"), new Object[0]);
    }

    public String getNewTitle() {
        return this.newTitle;
    }

    public void setNewTitle(String newTitle) {
        this.newTitle = newTitle;
    }
}

