/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingConstants;
import org.nuxeo.ecm.platform.routing.core.impl.ElementRunner;
import org.nuxeo.ecm.platform.routing.core.impl.EventFirer;
import org.nuxeo.runtime.api.Framework;

public class DocumentRouteElementImpl
implements DocumentRouteElement,
DocumentRouteStep {
    private static final long serialVersionUID = 1L;
    protected DocumentModel document;
    protected ElementRunner runner;

    public DocumentRouteElementImpl(DocumentModel doc, ElementRunner runner) {
        this.document = doc;
        this.runner = runner;
    }

    public DocumentModelList getAttachedDocuments(CoreSession session) {
        List docIds = this.getDocumentRoute(session).getAttachedDocuments();
        ArrayList<IdRef> refs = new ArrayList<IdRef>();
        for (String id : docIds) {
            refs.add(new IdRef(id));
        }
        try {
            return session.getDocuments(refs.toArray(new DocumentRef[0]));
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public void run(CoreSession session) {
        this.runner.run(session, this);
    }

    public DocumentRoute getDocumentRoute(CoreSession session) {
        DocumentModel parent = this.document;
        try {
            while (!parent.hasFacet("DocumentRoute")) {
                parent = session.getParentDocument(parent.getRef());
            }
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return (DocumentRoute)parent.getAdapter(DocumentRoute.class);
    }

    public DocumentModel getDocument() {
        return this.document;
    }

    protected Object getProperty(String propertyName) {
        try {
            return this.document.getPropertyValue(propertyName);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getName() {
        return (String)this.getProperty("dc:title");
    }

    public boolean isValidated() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.validated);
    }

    public boolean isReady() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.ready);
    }

    public boolean isDone() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.done);
    }

    protected boolean checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState state) {
        try {
            return this.document.getCurrentLifeCycleState().equalsIgnoreCase(state.name());
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public String getDescription() {
        return (String)this.getProperty("dc:description");
    }

    public boolean isRunning() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.running);
    }

    public boolean isCanceled() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.canceled);
    }

    public boolean isDraft() {
        return this.checkLifeCycleState(DocumentRouteElement.ElementLifeCycleState.draft);
    }

    public void setRunning(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toRunning, session, false);
    }

    public void followTransition(DocumentRouteElement.ElementLifeCycleTransistion transition, CoreSession session, boolean recursive) {
        try {
            if (this.document.followTransition(transition.name())) {
                if (Framework.isTestModeSet()) {
                    session.save();
                    ((EventService)Framework.getLocalService(EventService.class)).waitForAsyncCompletion();
                }
                this.document = session.getDocument(this.document.getRef());
            }
            if (recursive) {
                DocumentModelList children = session.getChildren(this.document.getRef());
                for (DocumentModel child : children) {
                    DocumentRouteElement element = (DocumentRouteElement)child.getAdapter(DocumentRouteElement.class);
                    element.followTransition(transition, session, recursive);
                }
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void save(CoreSession session) {
        try {
            session.saveDocument(this.document);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setDone(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDone, session, false);
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.afterStepRunning.name());
    }

    public void setValidated(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toValidated, session, true);
    }

    public void setReady(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toReady, session, true);
    }

    public void validate(CoreSession session) throws ClientException {
        this.setValidated(session);
        this.setReadOnly(session);
    }

    public void setReadOnly(CoreSession session) throws ClientException {
        SetDocumentOnReadOnlyUnrestrictedSessionRunner readOnlySetter = new SetDocumentOnReadOnlyUnrestrictedSessionRunner(session, this.document.getRef());
        readOnlySetter.runUnrestricted();
    }

    public boolean canValidateStep(CoreSession session) {
        return this.hasPermissionOnDocument(session, "WriteLifeCycle");
    }

    protected boolean hasPermissionOnDocument(CoreSession session, String permission) {
        try {
            return session.hasPermission(this.document.getRef(), permission);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public void setCanValidateStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "WriteLifeCycle");
    }

    protected void setPermissionOnDocument(CoreSession session, String userOrGroup, String permission) {
        ACPImpl acp = new ACPImpl();
        ACL routingACL = acp.getOrCreateACL("routing");
        routingACL.add((Object)new ACE(userOrGroup, permission, true));
        try {
            this.document.setACP((ACP)acp, true);
            session.saveDocument(this.document);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canUpdateStep(CoreSession session) {
        return this.hasPermissionOnDocument(session, "WriteProperties");
    }

    public void setCanUpdateStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "WriteProperties");
    }

    public boolean canDeleteStep(CoreSession session) {
        return this.hasPermissionOnDocument(session, "Remove");
    }

    public void setCanDeleteStep(CoreSession session, String userOrGroup) {
        this.setPermissionOnDocument(session, userOrGroup, "Remove");
    }

    public void backToReady(CoreSession session) {
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.beforeStepBackToReady.name());
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.backToReady, session, false);
        EventFirer.fireEvent(session, this, null, DocumentRoutingConstants.Events.afterStepBackToReady.name());
    }

    public DocumentRouteStep undo(CoreSession session) {
        this.runner.undo(session, this);
        try {
            this.document = session.getDocument(this.document.getRef());
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public boolean canUndoStep(CoreSession session) {
        try {
            GetIsParentRunningUnrestricted runner = new GetIsParentRunningUnrestricted(session);
            runner.runUnrestricted();
            return runner.isRunning();
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public void cancel(CoreSession session) {
        this.runner.cancel(session, this);
    }

    public void setCanceled(CoreSession session) {
        this.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toCanceled, session, false);
    }

    public boolean isModifiable() {
        return this.isDraft() || this.isReady() || this.isRunning();
    }

    protected class GetIsParentRunningUnrestricted
    extends UnrestrictedSessionRunner {
        protected boolean isRunning;

        public GetIsParentRunningUnrestricted(CoreSession session) {
            super(session);
        }

        public void run() throws ClientException {
            DocumentModel parent = this.session.getDocument(DocumentRouteElementImpl.this.document.getParentRef());
            DocumentRouteElement parentElement = (DocumentRouteElement)parent.getAdapter(DocumentRouteElement.class);
            this.isRunning = parentElement.isRunning();
        }

        public boolean isRunning() {
            return this.isRunning;
        }
    }

    protected class SetDocumentOnReadOnlyUnrestrictedSessionRunner
    extends UnrestrictedSessionRunner {
        protected DocumentRef ref;

        public SetDocumentOnReadOnlyUnrestrictedSessionRunner(CoreSession session, DocumentRef ref) {
            super(session);
            this.ref = ref;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getDocument(this.ref);
            ACPImpl acp = new ACPImpl();
            ACL routingACL = acp.getOrCreateACL("routing");
            routingACL.add((Object)new ACE("Everyone", "Read", true));
            ACL inheritedACL = acp.getOrCreateACL("inherited");
            inheritedACL.add((Object)new ACE("Everyone", "Everything", false));
            ACL localACL = acp.getOrCreateACL("local");
            localACL.add((Object)new ACE("Everyone", "Everything", false));
            doc.setACP((ACP)acp, true);
            this.session.saveDocument(doc);
        }
    }
}

