/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.pathsegment.PathSegmentService;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteTableElement;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingPersister;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.LockableDocumentRoute;
import org.nuxeo.ecm.platform.routing.api.RouteFolderElement;
import org.nuxeo.ecm.platform.routing.api.RouteTable;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteAlredayLockedException;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteNotLockedException;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.impl.ChainToTypeMappingDescriptor;
import org.nuxeo.ecm.platform.routing.core.impl.PersisterDescriptor;
import org.nuxeo.ecm.platform.routing.core.runner.CreateNewRouteInstanceUnrestricted;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class DocumentRoutingServiceImpl
extends DefaultComponent
implements DocumentRoutingService {
    private static final String AVAILABLE_ROUTES_QUERY = String.format("Select * from %s", "DocumentRoute");
    private static final String ORDERED_CHILDREN_QUERY = "SELECT * FROM Document WHERE ecm:parentId = '%s' AND ecm:isCheckedInVersion  = 0 AND ecm:mixinType != 'HiddenInNavigation' AND ecm:currentLifeCycleState != 'deleted' ORDER BY ecm:pos";
    public static final String CHAINS_TO_TYPE_XP = "chainsToType";
    public static final String PERSISTER_XP = "persister";
    protected Map<String, String> typeToChain = new HashMap<String, String>();
    protected Map<String, String> undoChainIdFromRunning = new HashMap<String, String>();
    protected Map<String, String> undoChainIdFromDone = new HashMap<String, String>();
    protected DocumentRoutingPersister persister;

    protected DocumentRoutingEngineService getEngineService() {
        try {
            return (DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (CHAINS_TO_TYPE_XP.equals(extensionPoint)) {
            ChainToTypeMappingDescriptor desc = (ChainToTypeMappingDescriptor)contribution;
            this.typeToChain.put(desc.getDocumentType(), desc.getChainId());
            this.undoChainIdFromRunning.put(desc.getDocumentType(), desc.getUndoChainIdFromRunning());
            this.undoChainIdFromDone.put(desc.getDocumentType(), desc.getUndoChainIdFromDone());
        } else if (PERSISTER_XP.equals(extensionPoint)) {
            PersisterDescriptor des = (PersisterDescriptor)contribution;
            this.persister = des.getKlass().newInstance();
        }
    }

    public DocumentRoute createNewInstance(DocumentRoute model, List<String> docIds, CoreSession session, boolean startInstance) {
        CreateNewRouteInstanceUnrestricted runner = new CreateNewRouteInstanceUnrestricted(session, model, docIds, startInstance, this.persister);
        try {
            runner.runUnrestricted();
            DocumentRef routeRef = runner.getInstance().getDocument().getRef();
            return (DocumentRoute)session.getDocument(routeRef).getAdapter(DocumentRoute.class);
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    public DocumentRoute createNewInstance(DocumentRoute model, String documentId, CoreSession session, boolean startInstance) {
        return this.createNewInstance(model, Collections.singletonList(documentId), session, startInstance);
    }

    public DocumentRoute createNewInstance(DocumentRoute model, List<String> documentIds, CoreSession session) {
        return this.createNewInstance(model, documentIds, session, true);
    }

    public DocumentRoute createNewInstance(DocumentRoute model, String documentId, CoreSession session) {
        return this.createNewInstance(model, Collections.singletonList(documentId), session, true);
    }

    public List<DocumentRoute> getAvailableDocumentRouteModel(CoreSession session) {
        DocumentModelList list = null;
        try {
            list = session.query(AVAILABLE_ROUTES_QUERY);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public String getOperationChainId(String documentType) {
        return this.typeToChain.get(documentType);
    }

    public String getUndoFromRunningOperationChainId(String documentType) {
        return this.undoChainIdFromRunning.get(documentType);
    }

    public String getUndoFromDoneOperationChainId(String documentType) {
        return this.undoChainIdFromDone.get(documentType);
    }

    public DocumentRoute unlockDocumentRouteUnrestrictedSession(final DocumentRoute routeModel, CoreSession userSession) throws ClientException {
        new UnrestrictedSessionRunner(userSession){

            public void run() throws ClientException {
                DocumentRoute route = (DocumentRoute)this.session.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
                LockableDocumentRoute lockableRoute = (LockableDocumentRoute)route.getDocument().getAdapter(LockableDocumentRoute.class);
                lockableRoute.unlockDocument(this.session);
            }
        }.runUnrestricted();
        return (DocumentRoute)userSession.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
    }

    public DocumentRoute validateRouteModel(final DocumentRoute routeModel, CoreSession userSession) throws DocumentRouteNotLockedException, ClientException {
        if (!routeModel.getDocument().isLocked()) {
            throw new DocumentRouteNotLockedException();
        }
        new UnrestrictedSessionRunner(userSession){

            public void run() throws ClientException {
                DocumentRoute route = (DocumentRoute)this.session.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
                route.validate(this.session);
            }
        }.runUnrestricted();
        return (DocumentRoute)userSession.getDocument(routeModel.getDocument().getRef()).getAdapter(DocumentRoute.class);
    }

    public List<DocumentRouteTableElement> getRouteElements(DocumentRoute route, CoreSession session) {
        RouteTable table = new RouteTable(route);
        ArrayList<DocumentRouteTableElement> elements = new ArrayList<DocumentRouteTableElement>();
        this.processElementsInFolder(route.getDocument(), elements, table, session, 0, null);
        int maxDepth = 0;
        for (DocumentRouteTableElement element : elements) {
            int d = element.getDepth();
            maxDepth = d > maxDepth ? d : maxDepth;
        }
        table.setMaxDepth(maxDepth);
        for (DocumentRouteTableElement element : elements) {
            element.computeFirstChildList();
        }
        return elements;
    }

    protected void processElementsInFolder(DocumentModel doc, List<DocumentRouteTableElement> elements, RouteTable table, CoreSession session, int depth, RouteFolderElement folder) {
        try {
            DocumentModelList children = session.getChildren(doc.getRef());
            boolean first = true;
            for (DocumentModel child : children) {
                if (child.isFolder() && !session.getChildren(child.getRef()).isEmpty()) {
                    RouteFolderElement thisFolder = new RouteFolderElement((DocumentRouteElement)child.getAdapter(DocumentRouteElement.class), table, first, folder, depth);
                    this.processElementsInFolder(child, elements, table, session, depth + 1, thisFolder);
                } else {
                    if (folder != null) {
                        folder.increaseTotalChildCount();
                    } else {
                        table.increaseTotalChildCount();
                    }
                    elements.add(new DocumentRouteTableElement((DocumentRouteElement)child.getAdapter(DocumentRouteElement.class), table, depth, folder, first));
                }
                first = false;
            }
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }

    protected List<DocumentRouteTableElement> getRouteElements(DocumentRouteElement routeElementDocument, CoreSession session, List<DocumentRouteTableElement> routeElements, int depth) {
        return null;
    }

    public List<DocumentRoute> getDocumentRoutesForAttachedDocument(CoreSession session, String attachedDocId) {
        ArrayList<DocumentRouteElement.ElementLifeCycleState> states = new ArrayList<DocumentRouteElement.ElementLifeCycleState>();
        states.add(DocumentRouteElement.ElementLifeCycleState.ready);
        states.add(DocumentRouteElement.ElementLifeCycleState.running);
        return this.getDocumentRoutesForAttachedDocument(session, attachedDocId, states);
    }

    public List<DocumentRoute> getDocumentRoutesForAttachedDocument(CoreSession session, String attachedDocId, List<DocumentRouteElement.ElementLifeCycleState> states) {
        DocumentModelList list = null;
        StringBuilder statesString = new StringBuilder();
        if (states != null && !states.isEmpty()) {
            statesString.append(" ecm:currentLifeCycleState IN (");
            for (DocumentRouteElement.ElementLifeCycleState state : states) {
                statesString.append("'" + state.name() + "',");
            }
            statesString.deleteCharAt(statesString.length() - 1);
            statesString.append(") AND");
        }
        String RELATED_TOUTES_QUERY = String.format(" SELECT * FROM DocumentRoute WHERE " + statesString.toString() + " docri:participatingDocuments IN ('%s') ", attachedDocId);
        try {
            list = session.query(RELATED_TOUTES_QUERY);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>();
        for (DocumentModel model : list) {
            routes.add((DocumentRoute)model.getAdapter(DocumentRoute.class));
        }
        return routes;
    }

    public boolean canUserValidateRoute(NuxeoPrincipal currentUser) {
        return currentUser.getGroups().contains("routeManagers");
    }

    public boolean canValidateRoute(DocumentModel documentRoute, CoreSession coreSession) throws ClientException {
        if (!coreSession.hasChildren(documentRoute.getRef())) {
            return false;
        }
        return coreSession.hasPermission(documentRoute.getRef(), "Everything");
    }

    public void addRouteElementToRoute(DocumentRef parentDocumentRef, int idx, DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        DocumentRoute route = this.getParentRouteModel(parentDocumentRef, session);
        if (!this.isLockedByCurrentUser(route, session)) {
            throw new DocumentRouteNotLockedException();
        }
        DocumentModelList children = session.query(String.format(ORDERED_CHILDREN_QUERY, session.getDocument(parentDocumentRef).getId()));
        try {
            DocumentModel sourceDoc = (DocumentModel)children.get(idx);
            this.addRouteElementToRoute(parentDocumentRef, sourceDoc.getName(), routeElement, session);
        }
        catch (IndexOutOfBoundsException e) {
            this.addRouteElementToRoute(parentDocumentRef, null, routeElement, session);
        }
    }

    public void addRouteElementToRoute(DocumentRef parentDocumentRef, String sourceName, DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        PathSegmentService pss;
        DocumentRoute parentRoute = this.getParentRouteModel(parentDocumentRef, session);
        if (!this.isLockedByCurrentUser(parentRoute, session)) {
            throw new DocumentRouteNotLockedException();
        }
        try {
            pss = (PathSegmentService)Framework.getService(PathSegmentService.class);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        DocumentModel docRouteElement = routeElement.getDocument();
        DocumentModel parentDocument = session.getDocument(parentDocumentRef);
        docRouteElement.setPathInfo(parentDocument.getPathAsString(), pss.generatePathSegment(docRouteElement));
        String lifecycleState = parentDocument.getCurrentLifeCycleState().equals(DocumentRouteElement.ElementLifeCycleState.draft.name()) ? DocumentRouteElement.ElementLifeCycleState.draft.name() : DocumentRouteElement.ElementLifeCycleState.ready.name();
        docRouteElement.putContextData("initialLifecycleState", (Serializable)((Object)lifecycleState));
        docRouteElement = session.createDocument(docRouteElement);
        session.orderBefore(parentDocumentRef, docRouteElement.getName(), sourceName);
        session.save();
    }

    public void removeRouteElement(DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        DocumentRoute parentRoute = routeElement.getDocumentRoute(session);
        if (!this.isLockedByCurrentUser(parentRoute, session)) {
            throw new DocumentRouteNotLockedException();
        }
        session.removeDocument(routeElement.getDocument().getRef());
        session.save();
    }

    public DocumentModelList getOrderedRouteElement(String routeElementId, CoreSession session) throws ClientException {
        String query = String.format(ORDERED_CHILDREN_QUERY, routeElementId);
        DocumentModelList orderedChildren = session.query(query);
        return orderedChildren;
    }

    public void lockDocumentRoute(DocumentRoute routeModel, CoreSession session) throws DocumentRouteAlredayLockedException, ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        boolean lockedByCurrent = this.isLockedByCurrentUser(routeModel, session);
        if (lockableRoute.isLocked(session) && !lockedByCurrent) {
            throw new DocumentRouteAlredayLockedException();
        }
        if (!lockedByCurrent) {
            lockableRoute.lockDocument(session);
        }
    }

    public void unlockDocumentRoute(DocumentRoute routeModel, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        if (!lockableRoute.isLockedByCurrentUser(session)) {
            throw new DocumentRouteNotLockedException();
        }
        lockableRoute.unlockDocument(session);
    }

    public boolean isLockedByCurrentUser(DocumentRoute routeModel, CoreSession session) throws ClientException {
        LockableDocumentRoute lockableRoute = (LockableDocumentRoute)routeModel.getDocument().getAdapter(LockableDocumentRoute.class);
        return lockableRoute.isLockedByCurrentUser(session);
    }

    public void updateRouteElement(DocumentRouteElement routeElement, CoreSession session) throws DocumentRouteNotLockedException, ClientException {
        if (!this.isLockedByCurrentUser(routeElement.getDocumentRoute(session), session)) {
            throw new DocumentRouteNotLockedException();
        }
        routeElement.save(session);
    }

    private DocumentRoute getParentRouteModel(DocumentRef documentRef, CoreSession session) throws ClientException {
        DocumentModel parentDoc = session.getDocument(documentRef);
        if (parentDoc.hasFacet("DocumentRoute")) {
            return (DocumentRoute)parentDoc.getAdapter(DocumentRoute.class);
        }
        DocumentRouteElement rElement = (DocumentRouteElement)parentDoc.getAdapter(DocumentRouteElement.class);
        return rElement.getDocumentRoute(session);
    }

    public DocumentRoute saveRouteAsNewModel(DocumentRoute instance, CoreSession session) {
        DocumentModel instanceModel = instance.getDocument();
        DocumentModel parent = this.persister.getParentFolderForNewModel(session, instanceModel);
        String newName = this.persister.getNewModelName(instanceModel);
        try {
            DocumentModel newmodel = this.persister.saveDocumentRouteInstanceAsNewModel(instanceModel, parent, newName, session);
            DocumentRoute newRoute = (DocumentRoute)newmodel.getAdapter(DocumentRoute.class);
            if (!newRoute.isDraft()) {
                newRoute.followTransition(DocumentRouteElement.ElementLifeCycleTransistion.toDraft, session, false);
            }
            newRoute.getDocument().setPropertyValue("dc:title", (Serializable)((Object)newName));
            newRoute.setAttachedDocuments(new ArrayList());
            newRoute.save(session);
            return newRoute;
        }
        catch (ClientException e) {
            throw new RuntimeException(e);
        }
    }
}

