/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.persistence;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public class TreeHelper {
    public static final String TITLE_PROPERTY_NAME = "dc:title";
    public static final String DELETED_STATE = "deleted";

    public static DocumentModel getOrCreateDateTreeFolder(CoreSession session, DocumentModel root, Date date, String folderType) throws ClientException {
        String subPath = new SimpleDateFormat("yyyy/MM/dd").format(date);
        return TreeHelper.getOrCreatePath(session, root, subPath, folderType);
    }

    public static DocumentModel getOrCreatePath(CoreSession session, DocumentModel root, String subPath, String folderType) throws ClientException {
        String[] pathSplit = subPath.split("/");
        String parentPath = root.getPathAsString();
        DocumentModel child = root;
        for (String id : pathSplit) {
            child = TreeHelper.getOrCreate(session, parentPath, id, folderType);
            parentPath = child.getPathAsString();
        }
        return child;
    }

    public static synchronized DocumentModel getOrCreate(CoreSession session, String rootPath, String id, String folderType) throws ClientException {
        DocumentModel existing;
        String path = String.format("%s/%s", rootPath, id);
        PathRef pathRef = new PathRef(path);
        boolean exists = session.exists((DocumentRef)pathRef);
        if (exists && !DELETED_STATE.equals((existing = session.getDocument((DocumentRef)pathRef)).getCurrentLifeCycleState())) {
            return existing;
        }
        DocumentModel newDocument = session.createDocumentModel(rootPath, IdUtils.generateId((String)id), folderType);
        newDocument.setPropertyValue(TITLE_PROPERTY_NAME, (Serializable)((Object)id));
        newDocument = session.createDocument(newDocument);
        return newDocument;
    }
}

