/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.cases;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.cases.LockableAdapter;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;

public class LockableAdapterImpl
implements LockableAdapter {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LockableAdapterImpl.class);
    protected final DocumentModel document;

    public LockableAdapterImpl(DocumentModel document) {
        this.document = document;
    }

    @Override
    public Lock lockDocument(CoreSession documentManager) throws ClientException {
        return this.document.setLock();
    }

    @Override
    public void unlockDocument(CoreSession documentManager) throws ClientException {
        Lock lock = documentManager.getLockInfo(this.document.getRef());
        if (lock != null) {
            DocumentRef ref = this.document.getRef();
            NuxeoPrincipal userName = (NuxeoPrincipal)documentManager.getPrincipal();
            if (userName.isAdministrator() || documentManager.hasPermission(ref, "Everything") || userName.getName().equals(lock.getOwner())) {
                if (documentManager.hasPermission(ref, "WriteProperties")) {
                    this.document.removeLock();
                } else {
                    log.error((Object)("Cannot unlock document " + this.document.getName()));
                }
            }
        }
    }

    @Override
    public boolean isLocked(CoreSession documentManager) throws ClientException {
        Lock lock = documentManager.getLockInfo(this.document.getRef());
        if (lock == null) {
            return false;
        }
        return !lock.getOwner().equals(documentManager.getPrincipal().getName());
    }

    @Override
    public boolean isLockedByCurrentUser(CoreSession documentManager) throws ClientException {
        Lock lock = documentManager.getLockInfo(this.document.getRef());
        if (lock == null) {
            return false;
        }
        return lock.getOwner().equals(documentManager.getPrincipal().getName());
    }
}

