/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.mail.actionpipe.parser;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.cm.contact.Contact;
import org.nuxeo.cm.contact.Contacts;
import org.nuxeo.cm.mail.actionpipe.MailActionPipeConstants;
import org.nuxeo.cm.mail.actionpipe.parser.MailBodyParser;

public class DefaultEnglishMailParser
implements MailBodyParser,
MailActionPipeConstants {
    public static final Log log = LogFactory.getLog(DefaultEnglishMailParser.class);
    public static final Pattern DEFAULT_CONTACT_PATTERN = Pattern.compile("\\s*\"?([^@<>\",]*?)\"?\\s*(<?)([^\"@<> ,]+@.+\\.[a-z]+)(>?).*?");
    public static final Pattern THUNDERBIRD_ENGLISH_HEADER_PATTERN = Pattern.compile("(.*?)Original Message(.*?)(Subject:)([^\r\n]+)[\r\n\\s]+(Date:)([^\r\n]+)[\r\n\\s]+(From:)([^\r\n]+)[\r\n\\s]+(To:)([^\r\n]+)[\r\n\\s]+((Cc:)([^\r\n]+))?[\r\n\\s]+.*", 32);
    public static final String DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss ZZZZZ";

    @Override
    public Pattern getHeaderPattern() {
        return THUNDERBIRD_ENGLISH_HEADER_PATTERN;
    }

    @Override
    public boolean parse(Matcher m, Map<String, Object> resultMap) {
        Contacts origSenders;
        if (log.isDebugEnabled()) {
            for (int i = 1; i < m.groupCount() + 1; ++i) {
                log.debug((Object)(i + ": " + m.group(i)));
            }
        }
        if ((origSenders = this.parseContacts(m.group(8))) != null && !origSenders.isEmpty()) {
            String origSenderName = ((Contact)origSenders.get(0)).getName();
            resultMap.put("originalSenderName", origSenderName);
        }
        resultMap.put("originalSenders", origSenders);
        if (m.group(6) != null) {
            resultMap.put("originalReceptionDate", this.parseDate(m.group(6)));
        }
        if (m.group(10) != null) {
            resultMap.put("originalToRecipients", this.parseContacts(m.group(10)));
        }
        Contacts ccContacts = new Contacts();
        if (m.group(13) != null) {
            ccContacts = this.parseContacts(m.group(13));
        }
        resultMap.put("originalCcRecipients", ccContacts);
        return true;
    }

    protected Contacts parseContacts(String contacts) {
        log.debug((Object)String.format("Parsing contacts '%s'", contacts));
        if (contacts != null && contacts.length() > 0) {
            String[] split = contacts.trim().split("[,;]\\w*");
            Contacts res = new Contacts();
            for (String contact : split) {
                Matcher m = this.getContactPattern().matcher(contact);
                Contact item = new Contact();
                if (!m.matches()) continue;
                if (log.isDebugEnabled()) {
                    for (int i = 1; i < m.groupCount() + 1; ++i) {
                        log.debug((Object)(i + ": " + m.group(i)));
                    }
                }
                String name = m.group(1).trim();
                String email = m.group(3).trim();
                item.setName(name);
                item.setEmail(email);
                res.add(item);
            }
            return res;
        }
        return null;
    }

    protected Pattern getContactPattern() {
        return DEFAULT_CONTACT_PATTERN;
    }

    protected Calendar parseDate(String dateString) {
        try {
            log.debug((Object)String.format("Parsing date '%s'", dateString));
            DateFormat sdf = this.getDateFormat();
            Date date = sdf.parse(dateString.trim());
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return cal;
        }
        catch (ParseException e) {
            log.error((Object)("Parsing date failed : " + dateString), (Throwable)e);
            return null;
        }
    }

    protected DateFormat getDateFormat() {
        return new SimpleDateFormat(DATE_FORMAT, Locale.ENGLISH);
    }
}

