/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.operation;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.cm.caselink.ActionableCaseLink;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.service.CaseDistributionService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Case.Management.Step.Remove.CaseLink", category="CaseManagement", label="Remove Case Links from Mailboxes", description="This operation remove case links from mailboxes fetching links from context and, if none, find the running link created from this step")
public class RemoveCaseLinkOperation {
    public static final String ID = "Case.Management.Step.Remove.CaseLink";
    public static final String DESCRIPTION = "This operation remove case links from mailboxes fetching links from context and, if none, find the running link created from this step";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;

    @OperationMethod
    public void removeCaseLink() throws ClientException {
        List<CaseLink> links = this.fetchCaseLinks();
        for (CaseLink link : links) {
            this.getDistributionService().removeCaseLink(link, this.context.getCoreSession());
        }
    }

    protected List<CaseLink> fetchCaseLinks() throws ClientException {
        List attachedLinks;
        ArrayList<CaseLink> links = new ArrayList<CaseLink>();
        CaseLink link = (CaseLink)this.context.get((Object)"operation.case.link.key");
        if (link != null) {
            links.add(link);
        }
        if ((attachedLinks = (List)this.context.get((Object)"operation.case.links.key")) != null && !attachedLinks.isEmpty()) {
            links.addAll(attachedLinks);
        }
        if (links.isEmpty()) {
            links.addAll(this.fetchCaseLinksFromStep());
        }
        return links;
    }

    protected List<CaseLink> fetchCaseLinksFromStep() throws ClientException {
        DocumentRouteStep step = (DocumentRouteStep)this.context.get((Object)"document.routing.step");
        String query = String.format("Select * from CaseLink where ecm:currentLifeCycleState = 'todo' and acslk:stepDocumentId = '%s'", step.getDocument().getId());
        DocumentModelList docs = this.session.query(query);
        ArrayList<CaseLink> result = new ArrayList<CaseLink>();
        for (DocumentModel doc : docs) {
            result.add((CaseLink)doc.getAdapter(ActionableCaseLink.class));
        }
        return result;
    }

    protected CaseDistributionService getDistributionService() {
        try {
            return (CaseDistributionService)Framework.getService(CaseDistributionService.class);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

