/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.cm.operation;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.cm.caselink.ActionableCaseLink;
import org.nuxeo.cm.caselink.CaseLink;
import org.nuxeo.cm.caselink.CaseLinkType;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.routing.api.DocumentRouteStep;

@Operation(id="Case.Management.Step.CaseLink.Mapping", category="CaseManagement", label="Step To CaseLink Mapping", description="Create a CaseLink from the value of the Step docuemnt")
public class StepToCaseLinkMappingOperation {
    public static final String STEP_PREFIX = "Step:";
    public static final String CASE_PREFIX = "Case:";
    public static final String ID = "Case.Management.Step.CaseLink.Mapping";
    @Context
    protected OperationContext context;
    @Param(name="actionnable")
    protected boolean actionnable = false;
    @Param(name="mappingProperties")
    protected Properties mappingProperties;
    @Param(name="leavingChainsProperties", required=false)
    protected Properties leavingChainsProperties;

    @OperationMethod
    public void mapCaseLinkOperation() {
        List links = (List)this.context.get((Object)"operation.case.links.key");
        CoreSession session = this.context.getCoreSession();
        for (CaseLink link : links) {
            link.setActionnable(this.actionnable);
            DocumentModel kaseDoc = link.getCase(session).getDocument();
            DocumentModel linkDoc = link.getDocument();
            DocumentRouteStep step = (DocumentRouteStep)this.context.get((Object)"document.routing.step");
            DocumentModel stepDoc = step.getDocument();
            HashMap<String, List<String>> recipients = new HashMap<String, List<String>>();
            try {
                String recipient = (String)((Object)step.getDocument().getPropertyValue("rtsk:distributionMailboxId"));
                step.setCanValidateStep(this.context.getCoreSession(), recipient);
                recipients.put(CaseLinkType.FOR_ACTION.name(), Arrays.asList(recipient));
                if (recipient != null) {
                    link.addInitialInternalParticipants(recipients);
                }
                for (Map.Entry prop : this.mappingProperties.entrySet()) {
                    String getter = (String)prop.getKey();
                    String setter = (String)prop.getValue();
                    DocumentModel setterDoc = null;
                    if (setter.startsWith(CASE_PREFIX)) {
                        setterDoc = kaseDoc;
                        setter = setter.substring(CASE_PREFIX.length());
                    } else if (setter.startsWith(STEP_PREFIX)) {
                        setterDoc = stepDoc;
                        setter = setter.substring(STEP_PREFIX.length());
                    }
                    linkDoc.setPropertyValue(getter, setterDoc.getPropertyValue(setter));
                }
                if (!link.isActionnable()) continue;
                ActionableCaseLink actionableLink = (ActionableCaseLink)link.getDocument().getAdapter(ActionableCaseLink.class);
                String refuseChainId = (String)this.leavingChainsProperties.get((Object)"refuse");
                String validateChainId = (String)this.leavingChainsProperties.get((Object)"validate");
                actionableLink.setRefuseOperationChainId(refuseChainId);
                actionableLink.setValidateOperationChainId(validateChainId);
                actionableLink.setStepId(stepDoc.getId());
            }
            catch (PropertyException e) {
                throw new RuntimeException(e);
            }
            catch (ClientException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

