/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.listeners;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;
import org.nuxeo.ecm.sync.cmis.api.CMISServiceConstants;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISImportService;
import org.nuxeo.runtime.api.Framework;

public class FolderishListener
implements EventListener,
PostCommitEventListener,
CMISServiceConstants {
    static final Log log = LogFactory.getLog(FolderishListener.class);
    protected CMISRemoteService cmis;

    private void checkServices() {
        if (this.cmis == null) {
            this.cmis = (CMISRemoteService)Framework.getService(CMISRemoteService.class);
        }
    }

    public void handleEvent(EventBundle events) {
        this.checkServices();
        for (Event evt : events) {
            DocumentEventContext context;
            if (!(evt.getContext() instanceof DocumentEventContext) || !this.filterDoc((context = (DocumentEventContext)evt.getContext()).getSourceDocument())) continue;
            this.execute(context);
        }
    }

    public void handleEvent(Event evt) {
        DocumentEventContext context;
        this.checkServices();
        if (evt.getContext() instanceof DocumentEventContext && this.filterDoc((context = (DocumentEventContext)evt.getContext()).getSourceDocument())) {
            this.execute(context);
        }
    }

    private boolean filterDoc(DocumentModel model) {
        return model != null && model.hasFacet("CMISSync") && model.hasFacet("Folderish") && model.getPropertyValue("cmissync:uid") != null && model.getPropertyValue("cmissync:state") != null && model.getPropertyValue("cmissync:state").equals("sync");
    }

    private void execute(DocumentEventContext context) {
        DocumentModel model = context.getSourceDocument();
        model.setPropertyValue("cmissync:state", (Serializable)((Object)"traversed"));
        CMISImportService imp = new CMISImportService(context.getCoreSession(), this.cmis);
        imp.setState("queued");
        imp.run(model);
    }
}

