/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.operations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISImportService;

@Operation(id="Repository.CMISImport", category="Fetch", label="CMIS Structure Import", description="Import CMIS content with a remote repository.")
public class CMISImport {
    public static final String ID = "Repository.CMISImport";
    static final Log log = LogFactory.getLog(CMISImport.class);
    @Context
    protected CoreSession session;
    @Context
    protected CMISRemoteService cmis;
    @Param(name="connection", required=false)
    protected String connection;
    @Param(name="remoteRef", required=false)
    protected String remoteRef;
    @Param(name="idRef", required=false, values={"false"})
    protected boolean idRef = false;
    @Param(name="force", required=false, values={"false"})
    protected boolean force = false;
    @Param(name="state", required=false)
    protected String state;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel target) {
        CMISImportService cmisImport = new CMISImportService(this.session, this.cmis);
        cmisImport.setConnectionName(this.connection);
        cmisImport.setRemoteRef(this.remoteRef);
        cmisImport.setIsIdRef(this.idRef);
        cmisImport.setForce(this.force);
        cmisImport.setState(this.state);
        DocumentModel result = cmisImport.run(target);
        return result;
    }
}

