/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.operations;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISSyncService;

@Operation(id="Document.CMISSync", category="Document", label="CMIS Document Synchronization", description="Synchronize CMIS content with a remote repository.")
public class CMISSync {
    public static final String ID = "Document.CMISSync";
    static final Log log = LogFactory.getLog(CMISSync.class);
    @Context
    protected CoreSession coreSession;
    @Context
    protected CMISRemoteService cmis;
    @Param(name="connection", required=false)
    protected String connection;
    @Param(name="remoteRef", required=false)
    protected String remoteRef;
    @Param(name="idRef", required=false, values={"false"})
    protected boolean idRef = false;
    @Param(name="force", required=false, values={"false"})
    protected boolean force = false;
    @Param(name="state", required=false)
    protected String state;
    @Param(name="content", required=false, values={"true"})
    protected boolean content = true;
    @Param(name="contentXPath", required=false, values={"file:content"})
    protected String contentXPath = "file:content";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel target) {
        CMISSyncService cmisSync = new CMISSyncService(this.coreSession, this.cmis);
        cmisSync.setConnectionName(this.connection);
        cmisSync.setRemoteRef(this.remoteRef);
        cmisSync.setIsIdRef(this.idRef);
        cmisSync.setForce(this.force);
        cmisSync.setState(this.state);
        cmisSync.setIsContent(this.content);
        cmisSync.setContentXPath(this.contentXPath);
        DocumentModel result = cmisSync.run(target);
        return result;
    }
}

