/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.service.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.Ace;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.Access;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.sync.cmis.api.CMISServiceConstants;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISUserMappingDescriptor;
import org.nuxeo.runtime.api.Framework;

public class CMISAceMapping
implements CMISServiceConstants {
    private static final Log log = LogFactory.getLog(CMISAceMapping.class);
    protected String connectionName;
    protected String method;
    protected Map<String, String> mapping;
    protected List<CMISUserMappingDescriptor> users;
    protected CoreSession coreSession;
    protected DocumentModel doc;
    protected CmisObject remote;
    protected UserManager userManager = null;

    public CMISAceMapping(String connectionName, String method, Map<String, String> mapping, List<CMISUserMappingDescriptor> users) {
        this.connectionName = connectionName;
        this.method = method;
        this.mapping = mapping;
        this.users = users;
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)Framework.getService(UserManager.class);
        }
        return this.userManager;
    }

    public DocumentModel applyMapping(CoreSession coreSession, DocumentModel doc, CmisObject remote) {
        this.coreSession = coreSession;
        this.doc = doc;
        this.remote = remote;
        switch (this.method) {
            case "replaceAll": {
                return this.applyWithReplaceAll();
            }
        }
        return this.applyWithAddIfNotSet();
    }

    protected String mapUser(String principal) {
        Optional<CMISUserMappingDescriptor> map = this.users.stream().filter(u -> principal.equals(u.getRemoteUser())).findFirst();
        if (map.isPresent()) {
            return map.get().getLocalUser();
        }
        return principal;
    }

    protected DocumentModel applyWithReplaceAll() {
        List remoteACEs;
        ACL[] acls;
        DocumentRef docRef = this.doc.getRef();
        ACP acp = this.doc.getACP();
        boolean permissionChanged = acp.blockInheritance("local", this.coreSession.getPrincipal().getName());
        if (permissionChanged) {
            this.doc.setACP(acp, true);
        }
        for (ACL acl : acls = acp.getACLs()) {
            if ("inherited".equals(acl.getName())) continue;
            acp.removeACL(acl.getName());
        }
        this.doc.setACP(acp, true);
        List list = remoteACEs = this.remote.getAcl() == null ? null : this.remote.getAcl().getAces();
        if (remoteACEs != null) {
            ACLImpl nuxeoAcl = new ACLImpl("CmisSync");
            acp.addACL((ACL)nuxeoAcl);
            for (Ace ace : remoteACEs) {
                String principalId = this.mapUser(ace.getPrincipalId());
                NuxeoPrincipal localPrincipal = this.getUserManager().getPrincipal(principalId);
                boolean isGroup = false;
                boolean isEveryone = false;
                if (localPrincipal == null) {
                    boolean bl = isGroup = this.getUserManager().getGroup(principalId) != null;
                }
                if (localPrincipal == null && !isGroup) {
                    isEveryone = "Everyone".equals(principalId);
                }
                if (localPrincipal == null && !isGroup && !isEveryone) {
                    log.warn((Object)("User/Group <" + principalId + "> not found, using Administrator"));
                    principalId = "Administrator";
                }
                for (String remotePerm : ace.getPermissions()) {
                    String localPerm = this.mapping.get(remotePerm);
                    if (localPerm == null) {
                        localPerm = remotePerm;
                    }
                    ACE nuxeoAce = new ACE(principalId, localPerm, true);
                    nuxeoAcl.add(nuxeoAce);
                }
            }
            this.coreSession.setACP(docRef, acp, false);
        }
        return this.doc;
    }

    protected DocumentModel applyWithAddIfNotSet() {
        DocumentRef docRef = this.doc.getRef();
        List remoteACEs = this.remote.getAcl() == null ? null : this.remote.getAcl().getAces();
        ACP localAcp = this.doc.getACP();
        if (remoteACEs != null) {
            for (Ace ace : remoteACEs) {
                String principalId = this.mapUser(ace.getPrincipalId());
                NuxeoPrincipal localPrincipal = this.getUserManager().getPrincipal(principalId);
                boolean isGroup = false;
                boolean isEveryone = false;
                if (localPrincipal == null) {
                    boolean bl = isGroup = this.getUserManager().getGroup(principalId) != null;
                }
                if (localPrincipal == null && !isGroup) {
                    isEveryone = "Everyone".equals(principalId);
                }
                if (localPrincipal == null && !isGroup && !isEveryone) {
                    log.warn((Object)("User/Group <" + principalId + "> not found, using Administrator"));
                    principalId = "Administrator";
                }
                for (String remotePerm : ace.getPermissions()) {
                    String localPerm = this.mapping.get(remotePerm);
                    if (localPerm == null) {
                        localPerm = remotePerm;
                        log.warn((Object)("Permission mapping for user <" + principalId + "> not found: <" + remotePerm + ">"));
                    }
                    boolean needAddPermission = false;
                    if (localPrincipal != null) {
                        if (!this.coreSession.hasPermission(localPrincipal, docRef, localPerm)) {
                            needAddPermission = true;
                        }
                    } else {
                        Access access = localAcp.getAccess(principalId, localPerm);
                        if (access == Access.UNKNOWN) {
                            needAddPermission = true;
                        }
                    }
                    if (!needAddPermission) continue;
                    ACPImpl acp = new ACPImpl();
                    ACLImpl nuxeoAcl = new ACLImpl("CmisSync");
                    acp.addACL((ACL)nuxeoAcl);
                    ACE nuxeoAce = new ACE(principalId, localPerm, true);
                    nuxeoAcl.add(nuxeoAce);
                    this.coreSession.setACP(docRef, (ACP)acp, false);
                }
            }
        }
        return this.doc;
    }

    public String getMethod() {
        return this.method;
    }
}

