/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.service.impl;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Folder;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;
import org.nuxeo.ecm.sync.cmis.api.CMISServiceConstants;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISOperations;

public class CMISImportService
extends CMISOperations
implements CMISServiceConstants {
    private static final Log log = LogFactory.getLog(CMISImportService.class);
    protected CoreSession coreSession;
    protected CMISRemoteService cmis;
    protected String connectionName;
    protected String remoteRef;
    protected boolean isIdRef = false;
    protected boolean force = false;
    protected String state;

    public CMISImportService(CoreSession coreSession, CMISRemoteService cmis) {
        this.coreSession = coreSession;
        this.cmis = cmis;
    }

    public DocumentModel run(DocumentModel target) {
        if (!target.isFolder()) {
            throw new IllegalArgumentException("Cannot import non-folderish documents");
        }
        if (this.coreSession == null) {
            this.coreSession = target.getCoreSession();
            if (this.coreSession == null) {
                throw new NuxeoException("No CoreSession available");
            }
        }
        AtomicReference<String> atomicRemoteRef = new AtomicReference<String>(this.remoteRef);
        AtomicBoolean idRef = new AtomicBoolean(this.isIdRef);
        DocumentModel model = this.loadDocument(this.coreSession, target, atomicRemoteRef, idRef);
        Property p = model.getProperty("cmissync:connection");
        this.connectionName = this.validateConnection(p, this.connectionName);
        Property repositoryProperty = model.getProperty("cmissync:repository");
        Session repo = this.createSession(this.connectionName, repositoryProperty, this.cmis);
        CmisObject remote = this.loadObject(repo, atomicRemoteRef.get(), idRef.get());
        this.checkObject(remote, model);
        if (remote instanceof Folder) {
            Folder folder = (Folder)remote;
            for (CmisObject obj : folder.getChildren()) {
                this.importObject(model, obj);
            }
        } else {
            log.warn((Object)("Remote object is not a folder: " + remote));
            throw new IllegalArgumentException("Cannot import non-folder documents");
        }
        model = this.coreSession.saveDocument(model);
        return model;
    }

    private void importObject(DocumentModel model, CmisObject obj) {
        if (StringUtils.isBlank((CharSequence)this.connectionName)) {
            throw new IllegalArgumentException("connectioName was not initialized");
        }
        Map<String, String> doctypeMapping = this.cmis.getDoctypeMapping(this.connectionName);
        String docType = "Document";
        String remoteDocType = obj.getType().getId();
        switch (obj.getBaseTypeId()) {
            case CMIS_DOCUMENT: {
                docType = (String)StringUtils.defaultIfBlank((CharSequence)doctypeMapping.get(remoteDocType), (CharSequence)"File");
                break;
            }
            case CMIS_FOLDER: {
                docType = (String)StringUtils.defaultIfBlank((CharSequence)doctypeMapping.get(remoteDocType), (CharSequence)"Folder");
                break;
            }
            case CMIS_ITEM: {
                docType = (String)StringUtils.defaultIfBlank((CharSequence)doctypeMapping.get(remoteDocType), (CharSequence)"File");
                break;
            }
            case CMIS_POLICY: {
                docType = "Policy";
                break;
            }
            case CMIS_RELATIONSHIP: {
                docType = "Relationship";
                break;
            }
            case CMIS_SECONDARY: {
                docType = "Secondary";
                break;
            }
        }
        try {
            DocumentModel child = this.coreSession.createDocumentModel(model.getPathAsString(), obj.getName(), docType);
            child.addFacet("CMISSync");
            child.setPropertyValue("dc:title", (Serializable)((Object)obj.getName()));
            child.setPropertyValue("cmissync:uid", (Serializable)((Object)obj.getId()));
            child.setPropertyValue("cmissync:type", (Serializable)((Object)obj.getBaseTypeId().value()));
            if (obj instanceof FileableCmisObject) {
                child.getProperty("cmissync:paths").setValue((Object)((FileableCmisObject)obj).getPaths());
            }
            child.setPropertyValue("cmissync:connection", (Serializable)((Object)this.connectionName));
            child.setPropertyValue("cmissync:repository", model.getPropertyValue("cmissync:repository"));
            child.setPropertyValue("cmissync:state", (Serializable)((Object)this.state));
            child = this.coreSession.getOrCreateDocument(child);
        }
        catch (Exception ex) {
            log.error((Object)"Error creating document", (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setConnectionName(String connectioName) {
        this.connectionName = connectioName;
    }

    public void setRemoteRef(String remoteRef) {
        this.remoteRef = remoteRef;
    }

    public void setIsIdRef(boolean isIdRef) {
        this.isIdRef = isIdRef;
    }

    public void setForce(boolean force) {
        this.force = force;
    }
}

