/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.service.impl;

import java.io.Serializable;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.FileableCmisObject;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;

public abstract class CMISOperations {
    private static final Log log = LogFactory.getLog(CMISOperations.class);

    protected DocumentModel loadDocument(CoreSession session, DocumentModel target, AtomicReference<String> remoteRef, AtomicBoolean idRef) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        if (target == null) {
            throw new NullPointerException("document");
        }
        DocumentModel model = target;
        if (!model.hasFacet("CMISSync")) {
            model.addFacet("CMISSync");
        }
        if (remoteRef.get() == null) {
            remoteRef.set((String)((Object)model.getPropertyValue("cmissync:uid")));
            idRef.set(true);
            if (remoteRef.get() == null) {
                throw new IllegalArgumentException("UID or path required for sync");
            }
        }
        return model;
    }

    protected String validateConnection(Property connectionProperty, String connection) {
        Property connect = connectionProperty;
        if (connect.getValue() != null && connection != null) {
            if (!connect.getValue().equals(connection)) {
                throw new IllegalArgumentException("Mis-matched repository connection");
            }
        } else if (connection != null) {
            connect.setValue((Object)connection);
        } else {
            connection = (String)((Object)connect.getValue());
        }
        return connection;
    }

    protected Session createSession(String connectionName, Property repositoryProperty, CMISRemoteService cmis) {
        Session repo = cmis.createSession(connectionName);
        String repoId = repo.getRepositoryInfo().getId();
        if (repositoryProperty.getValue() == null) {
            repositoryProperty.setValue((Object)repoId);
        } else if (!repositoryProperty.getValue().equals(repoId)) {
            throw new IllegalArgumentException("Mis-matched remote repository identifier: " + repositoryProperty.getValue() + " != " + repoId);
        }
        return repo;
    }

    protected CmisObject loadObject(Session repo, String remoteRef, boolean idRef) {
        if (!remoteRef.startsWith("/") && !idRef) {
            log.warn((Object)("Using ID reference for non-path like value: " + remoteRef));
            idRef = true;
        }
        CmisObject remote = null;
        try {
            remote = idRef ? repo.getObject(remoteRef) : repo.getObjectByPath(remoteRef);
        }
        catch (CmisObjectNotFoundException cmisObjectNotFoundException) {
            // empty catch block
        }
        if (remote == null) {
            throw new IllegalArgumentException("Remote reference not found: " + remoteRef);
        }
        return remote;
    }

    protected void checkObject(CmisObject remote, DocumentModel model) {
        if (model.getPropertyValue("cmissync:uid") == null) {
            model.setPropertyValue("cmissync:uid", (Serializable)((Object)remote.getId()));
            model.setPropertyValue("cmissync:type", (Serializable)((Object)remote.getBaseTypeId().value()));
            if (remote instanceof FileableCmisObject) {
                FileableCmisObject pathy = (FileableCmisObject)remote;
                model.setPropertyValue("cmissync:paths", (Serializable)((Object)pathy.getPaths()));
            }
        } else if (!model.getPropertyValue("cmissync:uid").equals(remote.getId())) {
            throw new IllegalArgumentException("Mis-matched remote document UUID: " + model.getPropertyValue("cmissync:uid") + " != " + remote.getId());
        }
    }

    protected boolean requiresUpdate(CmisObject remote, DocumentModel doc, boolean force) {
        GregorianCalendar syncRef = (GregorianCalendar)doc.getPropertyValue("cmissync:synchronized");
        GregorianCalendar cal = remote.getLastModificationDate();
        return force || syncRef == null || cal.after(syncRef);
    }

    protected DocumentModel updateSyncAttributes(CmisObject remote, DocumentModel doc, String state) {
        if (state != null) {
            doc.setPropertyValue("cmissync:state", (Serializable)((Object)state));
        }
        doc.setPropertyValue("cmissync:synchronized", (Serializable)new Date());
        doc.setPropertyValue("cmissync:modified", (Serializable)remote.getLastModificationDate().getTime());
        return doc;
    }
}

