/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.service.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.chemistry.opencmis.client.SessionParameterMap;
import org.apache.chemistry.opencmis.client.api.OperationContext;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.client.runtime.OperationContextImpl;
import org.apache.chemistry.opencmis.client.runtime.SessionFactoryImpl;
import org.apache.chemistry.opencmis.commons.enums.BindingType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISAceMapping;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISConnectionDescriptor;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISFieldMappingDescriptor;
import org.nuxeo.ecm.sync.cmis.service.impl.DefaultFieldMappings;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class CMISRemoteServiceComponent
extends DefaultComponent
implements CMISRemoteService {
    private static final Log log = LogFactory.getLog(CMISRemoteServiceComponent.class);
    public static final String EP_CONNECTION = "connection";
    protected Map<String, Map<String, String>> doctypeMapping = null;
    protected Map<String, Map<String, CMISFieldMappingDescriptor>> fieldMapping = null;
    protected Map<String, CMISAceMapping> aceMapping = null;
    protected Map<String, CMISConnectionDescriptor> connections = null;

    public void activate(ComponentContext context) {
        this.doctypeMapping = new HashMap<String, Map<String, String>>();
        this.fieldMapping = new HashMap<String, Map<String, CMISFieldMappingDescriptor>>();
        this.aceMapping = new HashMap<String, CMISAceMapping>();
        this.connections = new HashMap<String, CMISConnectionDescriptor>();
    }

    public void deactivate(ComponentContext context) {
        this.doctypeMapping = null;
        this.fieldMapping = null;
        this.aceMapping = null;
        this.connections = null;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_CONNECTION.equals(extensionPoint)) {
            CMISConnectionDescriptor desc = (CMISConnectionDescriptor)contribution;
            String name = desc.getName();
            log.debug((Object)("Registering connection: " + name + ", repository: " + desc.getRepository()));
            if (!desc.isEnabled()) {
                this.connections.remove(name);
                log.info((Object)("Connection configured to not be enabled: " + name));
                return;
            }
            this.doctypeMapping.put(name, desc.getDoctypeMapping());
            CMISAceMapping aceMappingMap = new CMISAceMapping(name, desc.getAceMappingMethod(), desc.getAceMapping(), desc.getUserMapping());
            this.aceMapping.put(name, aceMappingMap);
            List<CMISFieldMappingDescriptor> loadedFieldMapping = desc.getFieldMapping();
            HashMap fieldMappingMap = new HashMap();
            DefaultFieldMappings.MAPPINGS.forEach(field -> fieldMappingMap.put(field.getName(), field));
            loadedFieldMapping.forEach(oneDesc -> fieldMappingMap.put(oneDesc.getName(), oneDesc));
            this.fieldMapping.put(name, fieldMappingMap);
            this.connections.put(name, desc);
        }
    }

    @Override
    public List<CMISFieldMappingDescriptor> getFieldMapping(String connectionName, String doctype) {
        Map<String, CMISFieldMappingDescriptor> fieldMappingMap = this.fieldMapping.get(connectionName);
        return fieldMappingMap.values().stream().filter(m -> m.matches(doctype)).collect(Collectors.toList());
    }

    @Override
    public CMISAceMapping getAceMappings(String connectionName) {
        return this.aceMapping.get(connectionName);
    }

    @Override
    public Collection<String> getConnectionNames() {
        return Collections.unmodifiableSet(this.connections.keySet());
    }

    @Override
    public Map<String, String> getDoctypeMapping(String connectionName) {
        return this.doctypeMapping.get(connectionName);
    }

    @Override
    public Session createSession(String connectionName) {
        CMISConnectionDescriptor desc = this.connections.get(connectionName);
        if (desc == null) {
            throw new IllegalArgumentException("No such connection: " + connectionName);
        }
        if (desc.getUrl() == null) {
            throw new IllegalArgumentException("No URL provided for connection: " + connectionName);
        }
        SessionFactoryImpl sessionFactory = SessionFactoryImpl.newInstance();
        SessionParameterMap parameter = new SessionParameterMap(desc.getProperties());
        if (desc.getUsername() != null && desc.getCredentials() != null) {
            parameter.setBasicAuthentication(desc.getUsername(), desc.getCredentials());
        }
        if (desc.getRepository() != null) {
            parameter.put((Object)"org.apache.chemistry.opencmis.session.repository.id", (Object)desc.getRepository());
        }
        String binding = desc.getBinding().toUpperCase();
        BindingType bt = BindingType.valueOf((String)binding);
        switch (bt) {
            case ATOMPUB: {
                parameter.setAtomPubBindingUrl(desc.getUrl());
                break;
            }
            case BROWSER: {
                parameter.setBrowserBindingUrl(desc.getUrl());
                break;
            }
            case WEBSERVICES: {
                parameter.setWebServicesBindingUrl(desc.getUrl());
                break;
            }
        }
        Session session = sessionFactory.createSession((Map)parameter);
        OperationContextImpl oc = new OperationContextImpl();
        oc.setIncludeAcls(true);
        oc.setLoadSecondaryTypeProperties(true);
        oc.setIncludePolicies(true);
        session.setDefaultContext((OperationContext)oc);
        return session;
    }

    @Override
    public CMISConnectionDescriptor getConnectionDescriptor(String connectionName) {
        return this.connections.get(connectionName);
    }
}

