/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.sync.cmis.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.client.api.Session;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.sync.cmis.api.CMISRemoteService;
import org.nuxeo.ecm.sync.cmis.api.CMISServiceConstants;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISAceMapping;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISFieldMappingDescriptor;
import org.nuxeo.ecm.sync.cmis.service.impl.CMISOperations;
import org.nuxeo.runtime.api.Framework;

public class CMISSyncService
extends CMISOperations
implements CMISServiceConstants {
    private static final Log log = LogFactory.getLog(CMISSyncService.class);
    protected CoreSession coreSession;
    protected CMISRemoteService cmis;
    protected String connectionName;
    protected String remoteRef;
    protected boolean isIdRef = false;
    protected boolean force = false;
    protected String state;
    protected boolean isContent = true;
    protected String contentXPath = "file:content";
    protected UserManager userManager = null;

    public CMISSyncService(CoreSession session, CMISRemoteService cmis) {
        this.coreSession = session;
        this.cmis = cmis;
    }

    public DocumentModel run(DocumentModel target) {
        AtomicReference<String> atomicRemoteRef = new AtomicReference<String>(this.remoteRef);
        AtomicBoolean idRef = new AtomicBoolean(this.isIdRef);
        DocumentModel model = this.loadDocument(this.coreSession, target, atomicRemoteRef, idRef);
        Property connectionProperty = model.getProperty("cmissync:connection");
        this.connectionName = this.validateConnection(connectionProperty, this.connectionName);
        Property repositoryProperty = model.getProperty("cmissync:repository");
        Session repo = this.createSession(this.connectionName, repositoryProperty, this.cmis);
        CmisObject remote = this.loadObject(repo, atomicRemoteRef.get(), idRef.get());
        this.checkObject(remote, model);
        if (this.requiresUpdate(remote, model, this.force)) {
            List<CMISFieldMappingDescriptor> descs = this.cmis.getFieldMapping(this.connectionName, model.getDocumentType().getName());
            for (CMISFieldMappingDescriptor desc : descs) {
                Object val = remote.getPropertyValue(desc.getProperty());
                Property dp = model.getProperty(desc.getXpath());
                if (val != null) {
                    dp.setValue(val);
                    continue;
                }
                dp.remove();
            }
            if (this.isContent && remote instanceof Document) {
                try {
                    Document rdoc = (Document)remote;
                    ContentStream rstream = rdoc.getContentStream();
                    if (rstream != null) {
                        Blob blb = Blobs.createBlob((InputStream)rstream.getStream());
                        blb.setFilename(rstream.getFileName());
                        blb.setMimeType(rstream.getMimeType());
                        DocumentHelper.addBlob((Property)model.getProperty(this.contentXPath), (Blob)blb);
                        model.setPropertyValue("cmissync:uri", (Serializable)((Object)rdoc.getContentUrl()));
                    }
                }
                catch (IOException iox) {
                    log.warn((Object)"Unable to copy remote content", (Throwable)iox);
                }
            }
            CMISAceMapping aceMapping = this.cmis.getAceMappings(this.connectionName);
            model = aceMapping.applyMapping(this.coreSession, model, remote);
        }
        this.updateSyncAttributes(remote, model, this.state);
        model = this.coreSession.saveDocument(model);
        return model;
    }

    protected UserManager getUserManager() {
        if (this.userManager == null) {
            this.userManager = (UserManager)Framework.getService(UserManager.class);
        }
        return this.userManager;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setConnectionName(String connectioName) {
        this.connectionName = connectioName;
    }

    public void setRemoteRef(String remoteRef) {
        this.remoteRef = remoteRef;
    }

    public void setIsIdRef(boolean isIdRef) {
        this.isIdRef = isIdRef;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isContent() {
        return this.isContent;
    }

    public void setIsContent(boolean isContent) {
        this.isContent = isContent;
    }

    public String getContentXPath() {
        return this.contentXPath;
    }

    public void setContentXPath(String contentXPath) {
        this.contentXPath = contentXPath;
    }
}

