/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.compound.filemanager;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.service.extension.DefaultFileImporter;
import org.nuxeo.labs.compound.service.CompoundDocumentService;
import org.nuxeo.runtime.api.Framework;

public class CompoundDocumentArchiveImporter
extends DefaultFileImporter {
    protected static final Log log = LogFactory.getLog(CompoundDocumentArchiveImporter.class);

    public DocumentModel createOrUpdate(FileImporterContext context) throws IOException {
        try {
            CoreSession session = context.getSession();
            CompoundDocumentService CompoundDocumentService2 = (CompoundDocumentService)Framework.getService(CompoundDocumentService.class);
            DocumentModel parent = session.getDocument((DocumentRef)new PathRef(context.getParentPath()));
            String targetType = CompoundDocumentService2.getTargetCompoundDocumentTypeFromContext(parent, context.getBlob());
            if (StringUtils.isNotEmpty((CharSequence)targetType)) {
                this.checkAllowedSubtypes(session, parent.getPathAsString(), targetType);
                return CompoundDocumentService2.createCompoundFromArchive(parent, targetType, context.getBlob());
            }
            return null;
        }
        catch (NuxeoException e) {
            log.error((Object)e);
            return null;
        }
    }
}

