/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.fsexporter;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.nuxeo.ecm.collections.core.adapter.Collection;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.io.fsexporter.DefaultExporterPlugin;
import org.nuxeo.io.fsexporter.ExportLogicDescriptor;
import org.nuxeo.io.fsexporter.FSExporterPlugin;
import org.nuxeo.io.fsexporter.FSExporterService;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class FSExporter
extends DefaultComponent
implements FSExporterService {
    protected FSExporterPlugin exporter = new DefaultExporterPlugin();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ExportLogicDescriptor exportLogicDesc = (ExportLogicDescriptor)contribution;
        if (exportLogicDesc.plugin != null) {
            try {
                this.exporter = exportLogicDesc.plugin.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Failed to instantiate " + exportLogicDesc.plugin, (Throwable)e);
            }
        }
    }

    @Override
    public void export(CoreSession session, String rootPath, String fspath, String PageProvider) throws IOException {
        DocumentModel root = session.getDocument((DocumentRef)new PathRef(rootPath));
        this.serializeStructure(session, fspath, root, PageProvider);
    }

    private void serializeStructure(CoreSession session, String fsPath, DocumentModel doc, String PageProvider) throws IOException {
        block3: {
            File serialized;
            block2: {
                serialized = this.exporter.serialize(session, doc, fsPath);
                if (!doc.isFolder()) break block2;
                DocumentModelList children = this.exporter.getChildren(session, doc, PageProvider);
                for (DocumentModel child : children) {
                    this.serializeStructure(session, serialized.getAbsolutePath(), child, PageProvider);
                }
                break block3;
            }
            if (!doc.hasFacet("Collection")) break block3;
            List collectedDocs = ((Collection)doc.getAdapter(Collection.class)).getCollectedDocumentIds().stream().map(IdRef::new).map(arg_0 -> ((CoreSession)session).getDocument(arg_0)).collect(Collectors.toList());
            for (DocumentModel collected : collectedDocs) {
                this.serializeStructure(session, serialized.getAbsolutePath(), collected, PageProvider);
            }
        }
    }

    @Override
    public void exportXML(CoreSession session, String rootName, String fileSystemTarget) {
        throw new UnsupportedOperationException();
    }
}

