/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.compound.thumbnail;

import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailService;
import org.nuxeo.ecm.platform.thumbnail.factories.ThumbnailDocumentFactory;
import org.nuxeo.runtime.api.Framework;

public class CompoundDocumentThumbnailFactory
extends ThumbnailDocumentFactory {
    public Blob getThumbnail(DocumentModel doc, CoreSession session) {
        Blob blob;
        if (doc.hasFacet("Thumbnail") && (blob = (Blob)doc.getPropertyValue("thumb:thumbnail")) != null) {
            return blob;
        }
        String thumbnailDocId = (String)((Object)doc.getPropertyValue("compound:thumbnailDocument"));
        Blob thumbnailBlob = this.getThumbnailFromDocId(thumbnailDocId, session);
        if (thumbnailBlob != null) {
            return thumbnailBlob;
        }
        String previewDocId = (String)((Object)doc.getPropertyValue("compound:previewDocument"));
        thumbnailBlob = this.getThumbnailFromDocId(previewDocId, session);
        if (thumbnailBlob != null) {
            return thumbnailBlob;
        }
        return this.getDefaultThumbnail(doc);
    }

    public Blob getThumbnailFromDocId(String docId, CoreSession session) {
        if (StringUtils.isNotEmpty((CharSequence)docId)) {
            ThumbnailService thumbnailService = (ThumbnailService)Framework.getService(ThumbnailService.class);
            DocumentModel previewDoc = session.getDocument((DocumentRef)new IdRef(docId));
            return thumbnailService.getThumbnail(previewDoc, session);
        }
        return null;
    }
}

