/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.compound.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.service.FileManagerService;
import org.nuxeo.labs.compound.service.CompoundDocumentService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class CompoundDocumentServiceImpl
extends DefaultComponent
implements CompoundDocumentService {
    public static String TYPE_FILTER_KEY = "org.nuxeo.labs.compound.service.type.filter";
    public static String COMPOUND_TYPE_SCRIPT = "javascript.utils_get_compound_type";
    public static String SUB_FOLDER_TYPE_SCRIPT = "javascript.utils_get_compound_sub_folder_type";
    public static final String COMPOUND_ARCHIVE_IMPORTED = "compoundDocumentTreeImported";
    public static List<String> MARKER_BLACKLIST = Arrays.asList(".nuxeo-archive", "meta-data.csv");

    @Override
    public boolean isCompoundDocument(DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        return actionService.checkFilter(TYPE_FILTER_KEY, (ActionContext)actionContext);
    }

    @Override
    public String getTargetCompoundDocumentTypeFromContext(DocumentModel parent, Blob archiveBlob) {
        ArrayList<String> entries = new ArrayList<String>();
        if (!this.isSupportedArchiveFile(archiveBlob, entries)) {
            return null;
        }
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext(parent.getCoreSession());
        HashMap params = new HashMap();
        ctx.setInput((Object)parent);
        ctx.put("blob", (Object)archiveBlob);
        ctx.put("entries", entries);
        try {
            return (String)automationService.run(ctx, COMPOUND_TYPE_SCRIPT, params);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public String getSubFolderTypeFromContext(DocumentModel compound, String parentPath, String name) {
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext(compound.getCoreSession());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentPath", parentPath);
        params.put("folderName", name);
        ctx.setInput((Object)compound);
        try {
            return (String)automationService.run(ctx, SUB_FOLDER_TYPE_SCRIPT, params);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public DocumentModel createCompoundFromArchive(DocumentModel parent, String documentType, Blob archiveBlob) throws IOException {
        CoreSession session = parent.getCoreSession();
        String compoundName = FilenameUtils.removeExtension((String)archiveBlob.getFilename());
        DocumentModel compound = session.createDocumentModel(parent.getPathAsString(), compoundName, documentType);
        compound.setPropertyValue("dc:title", (Serializable)((Object)compoundName));
        compound = session.createDocument(compound);
        this.createStructureFromArchive(compound, archiveBlob);
        return compound;
    }

    @Override
    public void createStructureFromArchive(DocumentModel compound, Blob archiveBlob) throws IOException {
        ZipEntry entry;
        CoreSession session = compound.getCoreSession();
        FileManagerService fileManager = (FileManagerService)Framework.getService(FileManager.class);
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(archiveBlob.getStream()));
        while ((entry = zin.getNextEntry()) != null) {
            String fileName = entry.getName();
            if (fileName.startsWith("__MACOSX/") || fileName.startsWith(".") || fileName.contentEquals("desktop.ini") || fileName.contentEquals("Thumbs.db") || fileName.startsWith("Icon") || fileName.contentEquals("../") || fileName.endsWith(".DS_Store")) continue;
            Path path = Path.of(entry.getName(), new String[0]);
            String componentName = path.getFileName().toString();
            String ComponentParentPath = path.getParent() != null ? path.getParent().toString() : "";
            String nuxeoPath = compound.getPathAsString() + "/" + ComponentParentPath;
            if (entry.isDirectory()) {
                DocumentModel folder = fileManager.defaultCreateFolder(session, componentName, nuxeoPath, this.getSubFolderTypeFromContext(compound, nuxeoPath, componentName), true, true);
                if (folder != null) continue;
                throw new NuxeoException("Filemanager couldn't create the folder: " + nuxeoPath);
            }
            FileBlob fileBlob = new FileBlob((InputStream)new CloseShieldInputStream((InputStream)zin));
            fileBlob.setFilename(componentName);
            FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)fileBlob, (String)nuxeoPath).overwrite(true).build();
            fileManager.createOrUpdateDocument(context);
        }
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), compound);
        Event event = ctx.newEvent(COMPOUND_ARCHIVE_IMPORTED);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
        session.saveDocument(compound);
    }

    @Override
    public boolean isSupportedArchiveFile(Blob archiveBlob, List<String> outputEntryList) {
        boolean bl;
        if (!"application/zip".equals(archiveBlob.getMimeType())) {
            return false;
        }
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(archiveBlob.getStream()));
        try {
            ZipEntry entry;
            boolean isSupported = false;
            while ((entry = zin.getNextEntry()) != null && (isSupported = !MARKER_BLACKLIST.contains(entry.getName()))) {
                if (outputEntryList == null) continue;
                outputEntryList.add(entry.getName());
            }
            bl = isSupported;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        zin.close();
        return bl;
    }
}

