/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.compound.service;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.filemanager.api.FileImporterContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.ecm.platform.filemanager.service.FileManagerService;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.labs.compound.api.CompoundArchive;
import org.nuxeo.labs.compound.service.CompoundDocumentService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class CompoundDocumentServiceImpl
extends DefaultComponent
implements CompoundDocumentService {
    public static final String COMPOUND_ARCHIVE_IMPORTED = "compoundDocumentTreeImported";
    public static String TYPE_FILTER_KEY = "org.nuxeo.labs.compound.service.type.filter";
    public static String COMPOUND_TYPE_SCRIPT = "javascript.utils_get_compound_type";
    public static String SUB_FOLDER_TYPE_SCRIPT = "javascript.utils_get_compound_sub_folder_type";
    public static List<String> MARKER_BLACKLIST = Arrays.asList(".nuxeo-archive", "meta-data.csv");

    @Override
    public boolean isCompoundDocument(DocumentModel doc) {
        ActionManager actionService = (ActionManager)Framework.getService(ActionManager.class);
        ELActionContext actionContext = new ELActionContext();
        actionContext.setCurrentDocument(doc);
        return actionService.checkFilter(TYPE_FILTER_KEY, (ActionContext)actionContext);
    }

    @Override
    public String getTargetCompoundDocumentTypeFromContext(DocumentModel parent, CompoundArchive archive) {
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext(parent.getCoreSession());
        HashMap params = new HashMap();
        ctx.setInput((Object)parent);
        ctx.put("blob", (Object)archive.getBlob());
        ctx.put("entries", archive.getValidEntryList());
        try {
            return (String)automationService.run(ctx, COMPOUND_TYPE_SCRIPT, params);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public String getSubFolderTypeFromContext(DocumentModel compound, String parentPath, String name) {
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext(compound.getCoreSession());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("parentPath", parentPath);
        params.put("folderName", name);
        ctx.setInput((Object)compound);
        try {
            return (String)automationService.run(ctx, SUB_FOLDER_TYPE_SCRIPT, params);
        }
        catch (OperationException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public DocumentModel createCompoundFromArchive(DocumentModel parent, Blob archiveBlob, String documentType) throws IOException {
        CoreSession session = parent.getCoreSession();
        String compoundName = FilenameUtils.removeExtension((String)archiveBlob.getFilename());
        DocumentModel compound = session.createDocumentModel(parent.getPathAsString(), compoundName, documentType);
        compound.setPropertyValue("dc:title", (Serializable)((Object)compoundName));
        compound = session.createDocument(compound);
        this.createStructureFromArchive(compound, archiveBlob);
        return compound;
    }

    @Override
    public DocumentModel createCompoundFromArchive(DocumentModel parent, Blob archiveBlob) throws IOException {
        CompoundArchive archive = this.toCompoundArchive(archiveBlob);
        String targetType = this.getTargetCompoundDocumentTypeFromContext(parent, archive);
        if (StringUtils.isNotEmpty((CharSequence)targetType)) {
            TypeManager typeService = (TypeManager)Framework.getService(TypeManager.class);
            Type containerType = typeService.getType(parent.getType());
            if (containerType == null || !typeService.isAllowedSubType(targetType, parent.getType(), parent)) {
                return null;
            }
            return this.createCompoundFromArchive(parent, archiveBlob, targetType);
        }
        return null;
    }

    @Override
    public void createStructureFromArchive(DocumentModel compound, Blob archiveBlob) throws IOException {
        CompoundArchive archive = this.toCompoundArchive(archiveBlob);
        this.createStructureFromArchive(compound, archive);
    }

    public void createStructureFromArchive(DocumentModel compound, CompoundArchive archive) throws IOException {
        ZipEntry entry;
        CoreSession session = compound.getCoreSession();
        FileManagerService fileManager = (FileManagerService)Framework.getService(FileManager.class);
        String prefix = archive.getPathPrefix();
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(archive.getBlob().getStream()));
        while ((entry = zin.getNextEntry()) != null) {
            String entryName = entry.getName();
            if (!this.isValidEntry(entryName)) continue;
            if (StringUtils.isNotEmpty((CharSequence)prefix)) {
                if (prefix.length() >= entryName.length()) continue;
                entryName = entryName.substring(prefix.length());
            }
            String normalizedEntryName = entryName.endsWith("/") ? entryName.substring(0, entryName.length() - 1) : entryName;
            String componentName = FilenameUtils.getName((String)normalizedEntryName);
            String ComponentParentPath = FilenameUtils.getPath((String)normalizedEntryName);
            String nuxeoPath = compound.getPathAsString() + "/" + ComponentParentPath;
            if (entry.isDirectory()) {
                DocumentModel folder = fileManager.defaultCreateFolder(session, componentName, nuxeoPath, this.getSubFolderTypeFromContext(compound, nuxeoPath, componentName), true, true);
                if (folder != null) continue;
                throw new NuxeoException("Filemanager couldn't create the folder: " + nuxeoPath);
            }
            FileBlob fileBlob = new FileBlob((InputStream)new CloseShieldInputStream((InputStream)zin));
            fileBlob.setFilename(componentName);
            FileImporterContext context = FileImporterContext.builder((CoreSession)session, (Blob)fileBlob, (String)nuxeoPath).overwrite(true).build();
            fileManager.createOrUpdateDocument(context);
        }
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), compound);
        Event event = ctx.newEvent(COMPOUND_ARCHIVE_IMPORTED);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
        session.saveDocument(compound);
    }

    @Override
    public boolean isSupportedArchiveFile(Blob archiveBlob) {
        return this.toCompoundArchive(archiveBlob) != null;
    }

    public CompoundArchive toCompoundArchive(Blob archiveBlob) {
        CompoundArchive compoundArchive;
        ArrayList<String> validEntryList = new ArrayList<String>();
        String prefix = null;
        ZipInputStream zin = new ZipInputStream(new BufferedInputStream(archiveBlob.getStream()));
        try {
            ZipEntry entry;
            boolean isSupported = false;
            while ((entry = zin.getNextEntry()) != null && (isSupported = !MARKER_BLACKLIST.contains(entry.getName()))) {
                String name = entry.getName();
                if (!this.isValidEntry(name)) continue;
                validEntryList.add(name);
                String folderPath = entry.isDirectory() ? name : FilenameUtils.getPath((String)name);
                if (prefix == null) {
                    prefix = folderPath;
                    continue;
                }
                if (!StringUtils.isNotBlank((CharSequence)prefix)) continue;
                prefix = this.longestSubstr(prefix, folderPath);
            }
            if (!isSupported) {
                throw new NuxeoException("Unsupported archive");
            }
            compoundArchive = new CompoundArchive(archiveBlob, validEntryList, prefix);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zin.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        zin.close();
        return compoundArchive;
    }

    public boolean isValidEntry(String entry) {
        if (entry.contains("__MACOSX/") || entry.contains("../") || entry.endsWith(".DS_Store")) {
            return false;
        }
        Path path = Path.of(entry, new String[0]);
        String filename = path.getFileName().toString();
        return !filename.startsWith(".") && !filename.contentEquals("desktop.ini") && !filename.contentEquals("Thumbs.db") && !filename.startsWith("Icon");
    }

    public String longestSubstr(String s, String t) {
        if (s.isEmpty() || t.isEmpty()) {
            return "";
        }
        int m = s.length();
        int n = t.length();
        int cost = 0;
        int maxLen = 0;
        int[] p = new int[n];
        int[] d = new int[n];
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                cost = s.charAt(i) != t.charAt(j) ? 0 : (i == 0 || j == 0 ? 1 : p[j - 1] + 1);
                d[j] = cost;
                if (cost <= maxLen) continue;
                maxLen = cost;
            }
            int[] swap = p;
            p = d;
            d = swap;
        }
        return maxLen > 0 ? s.substring(0, maxLen) : "";
    }
}

