/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.compound.io;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.thumbnail.ThumbnailAdapter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.thumbnail.io.ThumbnailJsonEnricher;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class CompoundDocumentThumbnailEnricher
extends ThumbnailJsonEnricher {
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        if (!document.hasFacet("Compound") || document.getPropertyValue("compound:previewDocument") == null) {
            super.write(jg, document);
            return;
        }
        Blob thumbnail = ((ThumbnailAdapter)document.getAdapter(ThumbnailAdapter.class)).getThumbnail(document.getCoreSession());
        if (thumbnail == null || thumbnail.getDigest() == null) {
            super.write(jg, document);
            return;
        }
        jg.writeFieldName("thumbnail");
        jg.writeStartObject();
        jg.writeStringField("url", String.format("%s/api/v1/repo/%s/id/%s/@rendition/thumbnail?changeToken=%s", this.ctx.getBaseUrl().replaceAll("/$", ""), document.getRepositoryName(), document.getId(), URLEncoder.encode(StringUtils.defaultString((String)thumbnail.getDigest()), StandardCharsets.UTF_8)));
        jg.writeEndObject();
    }
}

