/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.compound.listener;

import java.io.IOException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.labs.compound.service.CompoundDocumentService;
import org.nuxeo.runtime.api.Framework;

public class CompoundDocumentNewVersionListener
implements EventListener {
    public static final String FILE_CONTENT = "file:content";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        CompoundDocumentService compoundDocumentService = (CompoundDocumentService)Framework.getService(CompoundDocumentService.class);
        if (!compoundDocumentService.isCompoundDocument(doc)) {
            return;
        }
        Boolean flag = (Boolean)doc.getContextData("structureUpdated");
        if (flag != null && flag.booleanValue()) {
            return;
        }
        Property fileProperty = doc.getProperty(FILE_CONTENT);
        Blob blob = (Blob)doc.getPropertyValue(FILE_CONTENT);
        if (blob == null || !fileProperty.isDirty() || !compoundDocumentService.isSupportedArchiveFile(blob)) {
            return;
        }
        try {
            compoundDocumentService.updateStructureFromArchive(doc, blob);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        doc.setPropertyValue(FILE_CONTENT, null);
    }
}

