/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.fsexporter;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.CoreQueryPageProviderDescriptor;
import org.nuxeo.io.fsexporter.FSExporterPlugin;
import org.nuxeo.runtime.api.Framework;

public class DefaultExporterPlugin
implements FSExporterPlugin {
    @Override
    public DocumentModelList getChildren(CoreSession session, DocumentModel doc, String customQuery) {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)session);
        Object query = StringUtils.isNotBlank((CharSequence)customQuery) ? (customQuery.toLowerCase().contains(" where") ? customQuery + " AND ecm:parentId = ?" : customQuery + " where ecm:parentId = ?") : "SELECT * FROM Document WHERE ecm:parentId = ? AND ecm:mixinType !='HiddenInNavigation' AND ecm:isVersion = 0 AND ecm:isTrashed = 0";
        CoreQueryPageProviderDescriptor desc = new CoreQueryPageProviderDescriptor();
        desc.setPattern((String)query);
        PageProviderService ppService = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProvider pp = ppService.getPageProvider("customPP", (PageProviderDefinition)desc, null, null, null, null, props, new Object[]{doc.getId()});
        int countPages = 1;
        DocumentModelListImpl children = new DocumentModelListImpl(pp.getCurrentPage());
        if (pp.getNumberOfPages() > 1L) {
            while ((long)countPages < pp.getNumberOfPages()) {
                pp.nextPage();
                List childrenTemp = pp.getCurrentPage();
                children.addAll((Collection)childrenTemp);
                ++countPages;
            }
        }
        return children;
    }

    @Override
    public File serialize(CoreSession session, DocumentModel docfrom, String fsPath) throws IOException {
        BlobHolder myblobholder;
        File newFolder = null;
        File folder = new File(fsPath);
        if (!folder.exists()) {
            folder.mkdir();
        }
        if ("/".equals(docfrom.getPathAsString())) {
            return folder;
        }
        if (docfrom.hasFacet("Folderish") || docfrom.hasFacet("Collection")) {
            newFolder = new File(fsPath + "/" + docfrom.getName());
            newFolder.mkdir();
        }
        if ((myblobholder = (BlobHolder)docfrom.getAdapter(BlobHolder.class)) != null) {
            List listblobs = myblobholder.getBlobs();
            int i = 1;
            for (Blob blob : listblobs) {
                String FileNameToExport = this.getFileName(blob, docfrom, folder, i);
                File target = new File(folder, FileNameToExport);
                blob.transferTo(target);
                ++i;
            }
        }
        if (newFolder != null) {
            folder = newFolder;
        }
        return folder;
    }

    protected String getFileName(Blob blob, DocumentModel docfrom, File folder, int i) {
        File alreadyExistingBlob;
        Object prefix = "";
        if (i != 1) {
            prefix = docfrom.getName() + "-";
        }
        if ((alreadyExistingBlob = new File(folder, (String)prefix + blob.getFilename())).exists()) {
            prefix = String.valueOf(new Date().getTime()) + "-" + (String)prefix;
        }
        return (String)prefix + blob.getFilename();
    }
}

