/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;
import org.nuxeo.ecm.csv.core.CSVImporterWork;

public class CSVImporterExtendedWork
extends CSVImporterWork {
    private static final String MARKER = "metadata.csv";
    private static final Logger log = LogManager.getLogger(CSVImporterExtendedWork.class);
    protected ZipFile zip = null;

    public CSVImporterExtendedWork(String repositoryName, String parentPath, String username, Blob csvBlob, CSVImporterOptions options) {
        super(repositoryName, parentPath, username, csvBlob, options);
    }

    public void work() {
        TransientStore store = CSVImporterExtendedWork.getStore();
        this.setStatus("Importing");
        this.openUserSession();
        CSVFormat csvFormat = CSVFormat.DEFAULT.withHeader(new String[0]).withEscape(this.options.getEscapeCharacter()).withCommentMarker(this.options.getCommentMarker()).withIgnoreSurroundingSpaces();
        try (CloseableFile cFile = this.getBlob().getCloseableFile();){
            this.getArchiveFileIfValid(cFile.getFile());
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        if (this.zip == null) {
            return;
        }
        ZipEntry index = this.zip.getEntry(MARKER);
        try (InputStreamReader in = new InputStreamReader(this.zip.getInputStream(index));
             CSVParser parser = csvFormat.parse((Reader)in);){
            this.doImport(parser);
        }
        catch (IOException e) {
            this.logError(0L, "Error while doing the import: %s", "label.csv.importer.errorDuringImport", new String[]{e.getMessage()});
            log.debug((Object)e, (Throwable)e);
        }
        store.putParameter(this.id, "logs", (Serializable)this.importLogs);
        if (this.options.sendEmail()) {
            this.setStatus("Sending email");
            this.sendMail();
        }
        this.setStatus(null);
    }

    protected Blob createBlobFromFilePath(String fileRelativePath) throws IOException {
        ZipEntry blobIndex = this.zip.getEntry(fileRelativePath);
        if (blobIndex != null) {
            Blob blob;
            try {
                blob = Blobs.createBlob((InputStream)this.zip.getInputStream(blobIndex));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            blob.setFilename(fileRelativePath);
            return blob;
        }
        return null;
    }

    public ZipFile getArchiveFileIfValid(File file) throws IOException {
        try {
            this.zip = new ZipFile(file);
        }
        catch (ZipException e) {
            log.debug("file is not a zipfile ! ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.debug("can not open zipfile ! ", (Throwable)e);
            return null;
        }
        ZipEntry marker = this.zip.getEntry(MARKER);
        if (marker == null) {
            this.zip.close();
            return null;
        }
        return this.zip;
    }

    public Blob getBlob() {
        return (Blob)CSVImporterExtendedWork.getStore().getBlobs(this.id).get(0);
    }
}

