/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.CloseableFile;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.csv.core.CSVImporterOptions;
import org.nuxeo.ecm.csv.core.CSVImporterWork;

public class CSVImporterExtendedWork
extends CSVImporterWork {
    private static final String MARKER = "metadata.csv";
    private static final Logger log = LogManager.getLogger(CSVImporterExtendedWork.class);
    protected ZipFile zip = null;

    public CSVImporterExtendedWork(String repositoryName, String parentPath, String username, Blob csvBlob, CSVImporterOptions options) {
        super(repositoryName, parentPath, username, csvBlob, options);
    }

    public void work() {
        TransientStore store = CSVImporterExtendedWork.getStore();
        this.setStatus("Importing");
        this.openUserSession();
        CSVFormat csvFormat = CSVFormat.DEFAULT.builder().setHeader(new String[0]).setEscape(this.options.getEscapeCharacter()).setCommentMarker(this.options.getCommentMarker()).setIgnoreSurroundingSpaces(true).build();
        try (CloseableFile cFile = this.getBlob().getCloseableFile();){
            this.getArchiveFileIfValid(cFile.getFile());
        }
        catch (IOException e) {
            log.error((Object)e);
        }
        if (this.zip == null) {
            return;
        }
        ZipEntry index = this.zip.getEntry(MARKER);
        try (InputStreamReader in = new InputStreamReader(this.zip.getInputStream(index));
             CSVParser parser = csvFormat.parse((Reader)in);){
            this.doImport(parser);
        }
        catch (IOException e) {
            this.logError(0L, "Error while doing the import: %s", "label.csv.importer.errorDuringImport", new String[]{e.getMessage()});
            log.debug((Object)e, (Throwable)e);
        }
        store.putParameter(this.id, "logs", (Serializable)this.importLogs);
        if (this.options.sendEmail()) {
            this.setStatus("Sending email");
            this.sendMail();
        }
        this.setStatus(null);
    }

    protected Blob createBlobFromFilePath(String fileRelativePath) {
        ZipEntry blobIndex = this.zip.getEntry(fileRelativePath);
        if (blobIndex != null) {
            Blob blob;
            try {
                blob = Blobs.createBlob((InputStream)this.zip.getInputStream(blobIndex));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            blob.setFilename(fileRelativePath);
            return blob;
        }
        return null;
    }

    protected Serializable convertValue(CompositeType compositeType, String fieldName, String headerValue, String stringValue, long lineNumber) {
        if (compositeType.hasField(fieldName)) {
            Field field = compositeType.getField(fieldName);
            if (field != null) {
                try {
                    Object fieldValue = null;
                    Type fieldType = field.getType();
                    if (fieldType.isComplexType()) {
                        if (fieldType instanceof ComplexType) {
                            ComplexType complex = (ComplexType)fieldType;
                            if (complex.getFieldsCount() == 6 && complex.hasField("digest") && (fieldValue = (Serializable)this.createBlobFromFilePath(stringValue)) == null) {
                                this.logError(lineNumber, "The file '%s' does not exist", "label.csv.importer.notExistingFile", new String[]{stringValue});
                                return null;
                            }
                        } else {
                            fieldValue = (String[])ComplexTypeJSONDecoder.decode((ComplexType)((ComplexType)fieldType), (String)stringValue);
                            this.replaceBlobs((Map)fieldValue);
                        }
                    } else if (fieldType.isListType()) {
                        Type listFieldType = ((ListType)fieldType).getFieldType();
                        if (listFieldType.isSimpleType()) {
                            fieldValue = stringValue.split(this.options.getListSeparatorRegex());
                        } else {
                            fieldValue = (Serializable)((Object)ComplexTypeJSONDecoder.decodeList((ListType)((ListType)fieldType), (String)stringValue));
                            this.replaceBlobs((List)fieldValue);
                        }
                    } else {
                        Type type = field.getType();
                        if (type instanceof SimpleTypeImpl) {
                            type = type.getSuperType();
                        }
                        if (type.isSimpleType()) {
                            if (type instanceof StringType) {
                                fieldValue = stringValue;
                            } else if (type instanceof IntegerType) {
                                fieldValue = Integer.valueOf(stringValue);
                            } else if (type instanceof LongType) {
                                fieldValue = Long.valueOf(stringValue);
                            } else if (type instanceof DoubleType) {
                                fieldValue = Double.valueOf(stringValue);
                            } else if (type instanceof BooleanType) {
                                fieldValue = Boolean.valueOf(stringValue);
                            } else if (type instanceof DateType) {
                                DateFormat dateFormat = this.options.getDateFormat();
                                fieldValue = dateFormat != null ? dateFormat.parse(stringValue) : stringValue;
                            }
                        }
                    }
                    return fieldValue;
                }
                catch (IOException | NumberFormatException | ParseException e) {
                    this.logError(lineNumber, "Unable to convert field '%s' with value '%s'", "label.csv.importer.cannotConvertFieldValue", new String[]{headerValue, stringValue});
                    log.debug((Object)e, (Throwable)e);
                }
            }
        } else {
            this.logError(lineNumber, "Field '%s' does not exist on type '%s'", "label.csv.importer.notExistingField", new String[]{headerValue, compositeType.getName()});
        }
        return null;
    }

    public ZipFile getArchiveFileIfValid(File file) throws IOException {
        try {
            this.zip = new ZipFile(file);
        }
        catch (ZipException e) {
            log.debug("file is not a zipfile ! ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.debug("can not open zipfile ! ", (Throwable)e);
            return null;
        }
        ZipEntry marker = this.zip.getEntry(MARKER);
        if (marker == null) {
            this.zip.close();
            return null;
        }
        return this.zip;
    }

    public Blob getBlob() {
        return (Blob)CSVImporterExtendedWork.getStore().getBlobs(this.id).get(0);
    }
}

