/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.util.Locale;
import org.nuxeo.common.utils.i18n.I18NUtils;

public class CSVImportLog {
    protected final long line;
    protected final Status status;
    protected final String message;
    protected final String localizedMessage;
    protected final Object[] params;

    public CSVImportLog(long line, Status status, String message, String localizedMessage, Object ... params) {
        this.line = line;
        this.status = status;
        this.message = message;
        this.localizedMessage = localizedMessage;
        this.params = params;
    }

    public long getLine() {
        return this.line;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String getLocalizedMessage() {
        return this.localizedMessage;
    }

    public Object[] getLocalizedMessageParams() {
        return this.params;
    }

    public String getI18nMessage(Locale locale) {
        return I18NUtils.getMessageString((String)"messages", (String)this.getLocalizedMessage(), (Object[])this.getLocalizedMessageParams(), (Locale)locale);
    }

    public String getI18nMessage() {
        return this.getI18nMessage(Locale.ENGLISH);
    }

    public boolean isSuccess() {
        return this.status == Status.SUCCESS;
    }

    public boolean isSkipped() {
        return this.status == Status.SKIPPED;
    }

    public boolean isError() {
        return this.status == Status.ERROR;
    }

    public static enum Status {
        SUCCESS,
        SKIPPED,
        ERROR;

    }
}

