/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Date;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;

public class CSVImportId {
    private static final Log log = LogFactory.getLog(CSVImportId.class);
    protected final String repositoryName;
    protected final String path;
    protected final String csvBlobDigest;
    protected final Date importDate;

    public static CSVImportId create(String repositoryName, String path, Blob csvBlob, Date importDate) {
        return CSVImportId.create(repositoryName, path, CSVImportId.computeDigest(csvBlob), importDate);
    }

    public static CSVImportId create(String repositoryName, String path, String csvBlobDigest, Date importDate) {
        return new CSVImportId(repositoryName, path, csvBlobDigest, importDate);
    }

    protected CSVImportId(String repositoryName, String path, String csvBlobDigest, Date importDate) {
        this.repositoryName = repositoryName;
        this.path = path;
        this.csvBlobDigest = csvBlobDigest;
        this.importDate = importDate;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public String toString() {
        return String.format("CSVImportId [repositoryName=%s, path=%s]", this.repositoryName, this.path);
    }

    protected static String computeDigest(Blob blob) {
        try {
            MessageDigest md = MessageDigest.getInstance("sha-256");
            if (!blob.isPersistent()) {
                blob = blob.persist();
            }
            DigestInputStream dis = new DigestInputStream(blob.getStream(), md);
            while (dis.available() > 0) {
                dis.read();
            }
            byte[] b = md.digest();
            return Base64.encodeBase64String((byte[])b);
        }
        catch (Exception e) {
            log.error((Object)String.format("Error while computing Blob digest: %s", e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            return "";
        }
    }
}

