/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.operations.notification.MailTemplateHelper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.csv.CSVImportId;
import org.nuxeo.ecm.csv.CSVImportLog;
import org.nuxeo.ecm.csv.CSVImportResult;
import org.nuxeo.ecm.csv.CSVImporter;
import org.nuxeo.ecm.csv.CSVImporterOptions;
import org.nuxeo.ecm.csv.Constants;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class CSVImporterWork
extends AbstractWork {
    private static final Log log = LogFactory.getLog(CSVImporterWork.class);
    private static final String TEMPLATE_IMPORT_RESULT = "templates/csvImportResult.ftl";
    public static final String CATEGORY_CSV_IMPORTER = "csvImporter";
    public static final String CONTENT_FILED_TYPE_NAME = "content";
    protected final CSVImportId id;
    protected String repositoryName;
    protected String parentPath;
    protected String username;
    protected Blob csvBlob;
    protected CSVImporterOptions options;
    protected DateFormat dateformat;
    protected Date startDate;
    protected List<CSVImportLog> importLogs = new ArrayList<CSVImportLog>();

    public CSVImporterWork(CSVImportId id) {
        this.id = id;
    }

    public CSVImporterWork(String repositoryName, String parentPath, String username, Blob csvBlob, CSVImporterOptions options) {
        this.startDate = new Date();
        this.id = CSVImportId.create(repositoryName, parentPath, csvBlob, this.startDate);
        this.repositoryName = repositoryName;
        this.parentPath = parentPath;
        this.username = username;
        this.csvBlob = csvBlob;
        this.options = options;
        this.dateformat = new SimpleDateFormat(options.getDateFormat());
    }

    public CSVImportId getId() {
        return this.id;
    }

    public String getCategory() {
        return CATEGORY_CSV_IMPORTER;
    }

    public String getTitle() {
        return String.format("CSV import in '%s'", this.parentPath);
    }

    public List<CSVImportLog> getImportLogs() {
        return new ArrayList<CSVImportLog>(this.importLogs);
    }

    public void work() throws Exception {
        this.setStatus("Importing");
        this.initSession(this.repositoryName);
        try {
            this.doImport(this.session);
        }
        catch (IOException e) {
            this.logError(0L, "Error while doing the import: %s", "label.csv.importer.errorDuringImport", e.getMessage());
            log.debug((Object)e, (Throwable)e);
        }
        if (this.options.sendEmail()) {
            this.setStatus("Sending email");
            this.sendMail(this.session);
        }
        this.setStatus(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doImport(CoreSession session) throws IOException {
        log.info((Object)String.format("Importing CSV file: %s", this.csvBlob.getFilename()));
        CSVReader csvReader = new CSVReader(this.csvBlob.getReader());
        String[] header = csvReader.readNext();
        if (header == null) {
            this.logError(0L, "No header line, empty file?", "label.csv.importer.emptyFile", new Object[0]);
            return;
        }
        int nameIndex = -1;
        int typeIndex = -1;
        for (int col = 0; col < header.length; ++col) {
            if (Constants.CSV_NAME_COL.equals(header[col])) {
                nameIndex = col;
                continue;
            }
            if (!Constants.CSV_TYPE_COL.equals(header[col])) continue;
            typeIndex = col;
        }
        if (nameIndex == -1 || typeIndex == -1) {
            this.logError(0L, "Missing 'name' or 'type' column", "label.csv.importer.missingNameOrTypeColumn", new Object[0]);
            return;
        }
        boolean transactionStarted = false;
        if (!this.isTransactionStarted) {
            this.startTransaction();
            transactionStarted = true;
        }
        try {
            int batchSize = this.options.getBatchSize();
            long docsCreatedCount = 0L;
            long lineNumber = 0L;
            while (true) {
                ++lineNumber;
                String[] line = csvReader.readNext();
                if (line == null) {
                    break;
                }
                if (line.length == 0) {
                    this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SKIPPED, "Empty line", "label.csv.importer.emptyLine", new Object[0]));
                    continue;
                }
                try {
                    if (!this.importLine(session, line, lineNumber, nameIndex, typeIndex, header) || ++docsCreatedCount % (long)batchSize != 0L) continue;
                    this.commitOrRollbackTransaction();
                    this.startTransaction();
                }
                catch (ClientException e) {
                    Throwable unwrappedException = CSVImporterWork.unwrapException(e);
                    this.logError(lineNumber, "Error while importing line: %s", "label.csv.importer.errorImportingLine", unwrappedException.getMessage());
                    log.debug((Object)unwrappedException, unwrappedException);
                }
            }
        }
        finally {
            this.commitOrRollbackTransaction();
            if (!transactionStarted) {
                this.startTransaction();
            }
        }
        log.info((Object)String.format("Done importing CSV file: %s", this.csvBlob.getFilename()));
    }

    protected boolean importLine(CoreSession session, String[] line, long lineNumber, int nameIndex, int typeIndex, String[] headerValues) throws ClientException {
        String name = line[nameIndex];
        String type = line[typeIndex];
        if (StringUtils.isBlank((String)name)) {
            this.logError(lineNumber, "Missing 'name' value", "label.csv.importer.missingNameValue", new Object[0]);
            return false;
        }
        if (StringUtils.isBlank((String)type)) {
            this.logError(lineNumber, "Missing 'type' value", "label.csv.importer.missingTypeValue", new Object[0]);
            return false;
        }
        DocumentType docType = ((SchemaManager)Framework.getLocalService(SchemaManager.class)).getDocumentType(type);
        if (docType == null) {
            this.logError(lineNumber, "The type '%s' does not exist", "label.csv.importer.notExistingType", type);
            return false;
        }
        Map<String, Serializable> values = this.computePropertiesMap(lineNumber, docType, headerValues, line);
        if (values == null) {
            return false;
        }
        return this.createOrUpdateDocument(lineNumber, session, this.parentPath, name, type, values);
    }

    protected Map<String, Serializable> computePropertiesMap(long lineNumber, DocumentType docType, String[] headerValues, String[] line) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (int col = 0; col < headerValues.length; ++col) {
            String headerValue = headerValues[col];
            String lineValue = line[col];
            lineValue = lineValue.trim();
            String fieldName = headerValue;
            if (Constants.CSV_NAME_COL.equals(headerValue) || Constants.CSV_TYPE_COL.equals(headerValue)) continue;
            if (!docType.hasField(fieldName)) {
                fieldName = fieldName.split(":")[1];
            }
            if (!docType.hasField(fieldName) || StringUtils.isBlank((String)lineValue)) continue;
            Serializable convertedValue = this.convertValue(docType, fieldName, headerValue, lineValue, lineNumber);
            if (convertedValue == null) {
                return null;
            }
            values.put(headerValue, convertedValue);
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Serializable convertValue(DocumentType docType, String fieldName, String headerValue, String stringValue, long lineNumber) {
        if (docType.hasField(fieldName)) {
            Field field = docType.getField(fieldName);
            if (field == null) return null;
            try {
                FileBlob fieldValue = null;
                Type fieldType = field.getType();
                if (fieldType.isComplexType()) {
                    if (!fieldType.getName().equals(CONTENT_FILED_TYPE_NAME)) return fieldValue;
                    String blobsFolderPath = Framework.getProperty((String)"nuxeo.csv.blobs.folder");
                    String path = FilenameUtils.normalize((String)(blobsFolderPath + "/" + (String)stringValue));
                    File file = new File(path);
                    if (file.exists()) {
                        FileBlob blob = new FileBlob(file);
                        blob.setFilename(file.getName());
                        return blob;
                    }
                    this.logError(lineNumber, "The file '%s' does not exist", "label.csv.importer.notExistingFile", new Object[]{stringValue});
                    return null;
                }
                if (fieldType.isListType()) {
                    Type listFieldType = ((ListType)fieldType).getFieldType();
                    if (!listFieldType.isSimpleType()) return (Serializable)((Object)Arrays.asList(stringValue.split(this.options.getListSeparatorRegex())));
                    return stringValue.split(this.options.getListSeparatorRegex());
                }
                if (!field.getType().isSimpleType()) return fieldValue;
                if (field.getType() instanceof StringType) {
                    return stringValue;
                }
                if (field.getType() instanceof IntegerType) {
                    return Integer.valueOf(Integer.parseInt((String)stringValue));
                }
                if (field.getType() instanceof LongType) {
                    return Long.valueOf(Long.parseLong((String)stringValue));
                }
                if (field.getType() instanceof DoubleType) {
                    return Double.valueOf(Double.parseDouble((String)stringValue));
                }
                if (field.getType() instanceof BooleanType) {
                    return Boolean.valueOf((String)stringValue);
                }
                if (!(field.getType() instanceof DateType)) return fieldValue;
                return this.dateformat.parse((String)stringValue);
            }
            catch (NumberFormatException | ParseException e) {
                this.logError(lineNumber, "Unable to convert field '%s' with value '%s'", "label.csv.importer.cannotConvertFieldValue", headerValue, stringValue);
                log.debug((Object)e, (Throwable)e);
                return null;
            }
        } else {
            this.logError(lineNumber, "Field '%s' does not exist on type '%s'", "label.csv.importer.notExistingField", headerValue, docType.getName());
        }
        return null;
    }

    protected boolean createOrUpdateDocument(long lineNumber, CoreSession session, String parentPath, String name, String type, Map<String, Serializable> properties) throws ClientException {
        String targetPath = new Path(parentPath).append(name).toString();
        PathRef docRef = new PathRef(targetPath);
        if (this.options.getCSVImporterDocumentFactory().exists(session, parentPath, name, type, properties)) {
            return this.updateDocument(lineNumber, session, (DocumentRef)docRef, properties);
        }
        return this.createDocument(lineNumber, session, parentPath, name, type, properties);
    }

    protected boolean createDocument(long lineNumber, CoreSession session, String parentPath, String name, String type, Map<String, Serializable> properties) {
        try {
            this.options.getCSVImporterDocumentFactory().createDocument(session, parentPath, name, type, properties);
            this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SUCCESS, "Document created", "label.csv.importer.documentCreated", new Object[0]));
            return true;
        }
        catch (ClientException e) {
            Throwable unwrappedException = CSVImporterWork.unwrapException(e);
            this.logError(lineNumber, "Unable to create document: %s", "label.csv.importer.unableToCreate", unwrappedException.getMessage());
            log.debug((Object)unwrappedException, unwrappedException);
            return false;
        }
    }

    protected boolean updateDocument(long lineNumber, CoreSession session, DocumentRef docRef, Map<String, Serializable> properties) {
        if (this.options.updateExisting()) {
            try {
                this.options.getCSVImporterDocumentFactory().updateDocument(session, docRef, properties);
                this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SUCCESS, "Document updated", "label.csv.importer.documentUpdated", new Object[0]));
                return true;
            }
            catch (ClientException e) {
                Throwable unwrappedException = CSVImporterWork.unwrapException(e);
                this.logError(lineNumber, "Unable to update document: %s", "label.csv.importer.unableToUpdate", unwrappedException.getMessage());
                log.debug((Object)unwrappedException, unwrappedException);
            }
        } else {
            this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.SKIPPED, "Document already exists", "label.csv.importer.documentAlreadyExists", new Object[0]));
        }
        return false;
    }

    protected void logError(long lineNumber, String message, String localizedMessage, Object ... params) {
        this.importLogs.add(new CSVImportLog(lineNumber, CSVImportLog.Status.ERROR, String.format(message, params), localizedMessage, params));
        String lineMessage = String.format("Line %d", lineNumber);
        String errorMessage = String.format(message, params);
        log.error((Object)String.format("%s: %s", lineMessage, errorMessage));
    }

    protected void sendMail(CoreSession session) throws Exception {
        UserManager userManager = (UserManager)Framework.getLocalService(UserManager.class);
        NuxeoPrincipal principal = userManager.getPrincipal(this.username);
        String email = principal.getEmail();
        if (email == null) {
            log.info((Object)String.format("Not sending import result email to '%s', no email configured", this.username));
            return;
        }
        OperationContext ctx = new OperationContext(session);
        ctx.setInput((Object)session.getRootDocument());
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        List<CSVImportLog> importLogs = csvImporter.getImportLogs(this.id);
        CSVImportResult importResult = CSVImportResult.fromImportLogs(importLogs);
        List<CSVImportLog> skippedAndErrorImportLogs = csvImporter.getImportLogs(this.id, CSVImportLog.Status.SKIPPED, CSVImportLog.Status.ERROR);
        ctx.put("importResult", (Object)importResult);
        ctx.put("skippedAndErrorImportLogs", skippedAndErrorImportLogs);
        ctx.put("csvFilename", (Object)this.csvBlob.getFilename());
        ctx.put("startDate", (Object)DateFormat.getInstance().format(this.startDate));
        ctx.put("username", (Object)this.username);
        DocumentModel importFolder = session.getDocument((DocumentRef)new PathRef(this.parentPath));
        String importFolderUrl = this.getDocumentUrl(importFolder);
        ctx.put("importFolderTitle", (Object)importFolder.getTitle());
        ctx.put("importFolderUrl", (Object)importFolderUrl);
        ctx.put("userUrl", (Object)this.getUserUrl(principal.getName()));
        StringList to = this.buildRecipientsList(email);
        Expression from = Scripting.newExpression((String)"Env[\"mail.from\"]");
        String subject = "CSV Import result of " + this.csvBlob.getFilename();
        String message = CSVImporterWork.loadTemplate(TEMPLATE_IMPORT_RESULT);
        try {
            OperationChain chain = new OperationChain("SendMail");
            chain.add("Notification.SendMail").set("from", (Object)from).set("to", (Object)to).set("HTML", (Object)true).set("subject", (Object)subject).set("message", (Object)message);
            ((AutomationService)Framework.getLocalService(AutomationService.class)).run(ctx, chain);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("interrupted", e);
        }
        catch (Exception e) {
            log.error((Object)String.format("Unable to notify user '%s' for import result of '%s': %s", this.username, this.csvBlob.getFilename(), e.getMessage()));
            log.debug((Object)e, (Throwable)e);
            throw e;
        }
    }

    protected String getDocumentUrl(DocumentModel doc) throws Exception {
        return MailTemplateHelper.getDocumentUrl((DocumentModel)doc, null);
    }

    protected String getUserUrl(String username) {
        NotificationService notificationService = NotificationServiceHelper.getNotificationService();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("username", username);
        DocumentViewImpl docView = new DocumentViewImpl(null, null, params);
        URLPolicyService urlPolicyService = (URLPolicyService)Framework.getLocalService(URLPolicyService.class);
        return urlPolicyService.getUrlFromDocumentView("user", (DocumentView)docView, notificationService.getServerUrlPrefix());
    }

    protected StringList buildRecipientsList(String userEmail) {
        String csvMailTo = Framework.getProperty((String)"nuxeo.csv.mail.to");
        if (StringUtils.isBlank((String)csvMailTo)) {
            return new StringList(new String[]{userEmail});
        }
        return new StringList(new String[]{userEmail, csvMailTo});
    }

    private static String loadTemplate(String key) {
        InputStream io = CSVImporterWork.class.getClassLoader().getResourceAsStream(key);
        if (io != null) {
            try {
                String string = FileUtils.read((InputStream)io);
                return string;
            }
            catch (IOException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
            finally {
                try {
                    io.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof CSVImporterWork)) {
            return false;
        }
        return this.id.equals(((CSVImporterWork)((Object)other)).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t instanceof ClientException || t instanceof Exception) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return CSVImporterWork.unwrapException(cause);
    }
}

