/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.csv.CSVImportId;
import org.nuxeo.ecm.csv.CSVImportLog;
import org.nuxeo.ecm.csv.CSVImportResult;
import org.nuxeo.ecm.csv.CSVImportStatus;
import org.nuxeo.ecm.csv.CSVImporter;
import org.nuxeo.ecm.csv.CSVImporterOptions;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.event.UploadEvent;
import org.richfaces.model.UploadItem;

@Scope(value=ScopeType.CONVERSATION)
@Name(value="csvImportActions")
@Install(precedence=10)
public class CSVImportActions
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected Blob csvBlob;
    protected boolean notifyUserByEmail = false;
    protected CSVImportId csvImportId;

    public boolean getNotifyUserByEmail() {
        return this.notifyUserByEmail;
    }

    public void setNotifyUserByEmail(boolean notifyUserByEmail) {
        this.notifyUserByEmail = notifyUserByEmail;
    }

    public void uploadListener(UploadEvent event) throws Exception {
        UploadItem item = event.getUploadItem();
        this.csvBlob = new FileBlob(item.getFile());
        this.csvBlob.setFilename(FilenameUtils.getName((String)item.getFileName()));
    }

    public void importCSVFile() {
        if (this.csvBlob != null) {
            CSVImporterOptions options = new CSVImporterOptions.Builder().sendEmail(this.notifyUserByEmail).build();
            CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
            this.csvImportId = csvImporter.launchImport(this.documentManager, this.navigationContext.getCurrentDocument().getPathAsString(), this.csvBlob, options);
        }
    }

    public String getImportingCSVFilename() {
        return this.csvBlob != null ? this.csvBlob.getFilename() : "";
    }

    public CSVImportStatus getImportStatus() {
        if (this.csvImportId == null) {
            return null;
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        return csvImporter.getImportStatus(this.csvImportId);
    }

    public List<CSVImportLog> getLastLogs(int maxLogs) {
        if (this.csvImportId == null) {
            return Collections.emptyList();
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        return csvImporter.getLastImportLogs(this.csvImportId, maxLogs);
    }

    public List<CSVImportLog> getSkippedAndErrorLogs() {
        if (this.csvImportId == null) {
            return Collections.emptyList();
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        return csvImporter.getImportLogs(this.csvImportId, CSVImportLog.Status.SKIPPED, CSVImportLog.Status.ERROR);
    }

    public CSVImportResult getImportResult() {
        if (this.csvImportId == null) {
            return null;
        }
        CSVImporter csvImporter = (CSVImporter)Framework.getLocalService(CSVImporter.class);
        return csvImporter.getImportResult(this.csvImportId);
    }

    @Observer(value={"navigateToDocument"})
    public void resetState() {
        this.csvBlob = null;
        this.csvImportId = null;
        this.notifyUserByEmail = false;
    }
}

