/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.csv;

import java.io.Serializable;
import org.nuxeo.ecm.csv.CSVImporterDocumentFactory;
import org.nuxeo.ecm.csv.DefaultCSVImporterDocumentFactory;

public class CSVImporterOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final CSVImporterOptions DEFAULT_OPTIONS = new Builder().build();
    protected final CSVImporterDocumentFactory CSVImporterDocumentFactory;
    protected final String dateFormat;
    protected final String listSeparatorRegex;
    protected final boolean updateExisting;
    protected final boolean checkAllowedSubTypes;
    protected final boolean sendEmail;
    protected final int batchSize;

    protected CSVImporterOptions(CSVImporterDocumentFactory CSVImporterDocumentFactory2, String dateFormat, String listSeparatorRegex, boolean updateExisting, boolean checkAllowedSubTypes, boolean sendEmail, int batchSize) {
        this.CSVImporterDocumentFactory = CSVImporterDocumentFactory2;
        this.dateFormat = dateFormat;
        this.listSeparatorRegex = listSeparatorRegex;
        this.updateExisting = updateExisting;
        this.checkAllowedSubTypes = checkAllowedSubTypes;
        this.sendEmail = sendEmail;
        this.batchSize = batchSize;
    }

    public CSVImporterDocumentFactory getCSVImporterDocumentFactory() {
        return this.CSVImporterDocumentFactory;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getListSeparatorRegex() {
        return this.listSeparatorRegex;
    }

    public boolean updateExisting() {
        return this.updateExisting;
    }

    public boolean checkAllowedSubTypes() {
        return this.checkAllowedSubTypes;
    }

    public boolean sendEmail() {
        return this.sendEmail;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public static class Builder {
        private CSVImporterDocumentFactory CSVImporterDocumentFactory = new DefaultCSVImporterDocumentFactory();
        private String dateFormat = "MM/dd/yyyy";
        private String listSeparatorRegex = "\\|";
        private boolean updateExisting = true;
        private boolean checkAllowedSubTypes = true;
        private boolean sendEmail = false;
        private int batchSize = 50;

        public Builder documentModelFactory(CSVImporterDocumentFactory factory) {
            this.CSVImporterDocumentFactory = factory;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder listSeparatorRegex(String listSeparatorRegex) {
            this.listSeparatorRegex = listSeparatorRegex;
            return this;
        }

        public Builder updateExisting(boolean updateExisting) {
            this.updateExisting = updateExisting;
            return this;
        }

        public Builder checkAllowedSubTypes(boolean checkAllowedSubTypes) {
            this.checkAllowedSubTypes = checkAllowedSubTypes;
            return this;
        }

        public Builder sendEmail(boolean sendEmail) {
            this.sendEmail = sendEmail;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public CSVImporterOptions build() {
            return new CSVImporterOptions(this.CSVImporterDocumentFactory, this.dateFormat, this.listSeparatorRegex, this.updateExisting, this.checkAllowedSubTypes, this.sendEmail, this.batchSize);
        }
    }
}

